

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDeletedAF_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDeletedAF_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDeletedAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDeletedAF_AfterDel]
  delete from GXDBVersions where name = 'MMDeletedAF_AfterDel' and type = 6
END
GO

	CREATE TRIGGER MMDeletedAF_AfterDel
 	ON MMDeletedAF
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		IF ((EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB')) AND (OBJECT_ID('HistoryDB..MMDeletedAFPruningLogs') IS NOT NULL))
		BEGIN
			INSERT INTO HistoryDB..MMDeletedAFPruningLogs (archFileId, VolumeId, Status, Retry, copyId, cclip, CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt, chunkCommCellId, PruneTime, ProcessId)
			SELECT D.archFileId, D.VolumeId, D.Status, D.Retry, D.copyId, D.cclip, D.CapacityFreedBytes, D.ArchChunkId, D.MountPathId, D.SIDBStoreId, D.CommCellId, D.DeletedTime, D.FailureErrorCode, D.subStoreBitField, D.sidbPruningFlag, D.appSizeFreedBytes, D.reserveInt, D.chunkCommCellId, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId
			FROM DELETED D, MMVolume V WITH (NOLOCK)
			WHERE (D.VolumeId > 0 AND D.VolumeId = V.VolumeId AND V.RecordingFormatId = 10001) OR (D.SIDBstoreId > 0 AND D.VolumeId = 0 AND D.VolumeId = V.VolumeId) -- either match vol and recfmt or match store with vol=0 row
		END
		-- We'll stop tracking if the config param is disabled. However, existing rows will be drained as usual.
     IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_DELETED_ARCHFILE_TRACKING_ENABLED' AND value > 0)
     BEGIN
     	INSERT INTO MMDeletedArchFileTracking (ArchFileId, CopyId, SIDBStoreId, CommCellId, RetryCount, DeletedTime, FailureErrorCode, SubStoreBitField, Flags)
     	SELECT DISTINCT D.archFileId, D.copyId, D.SIDBStoreId, D.CommCellId, 0, D.DeletedTime, 0, D.subStoreBitField, 0
     	FROM DELETED D
         		INNER JOIN IdxSIDBStore S WITH (READUNCOMMITTED) ON D.SIDBStoreId = S.SIDBStoreId AND D.CommCellId = S.CommCellId
					INNER JOIN archCopySIDBStore C WITH (READUNCOMMITTED) ON S.SIDBStoreId = C.SIDBStoreId
        			LEFT OUTER JOIN MMDeletedArchFileTracking T ON D.archFileId = T.ArchFileId AND D.CommCellId = T.commCellId AND D.SIDBStoreId = T.SIDBStoreId
     			WHERE (D.SIDBstoreId > 0 AND D.archFileId > 0 AND D.archChunkId > 0) AND D.archFileId <> 0x7FFFFFFF -- CVA_MAXINT
     			AND T.archFileId IS NULL
     			AND NOT (S.SealedTime > 0 AND S.Status = 1) -- IDX_SIDBSTORE_STATUS_CORRUPTED
					AND (S.flags & (256|2097152)) = 0 -- IDX_SIDBSTORE_FLAGS_SILO_AGED | IDX_SIDBSTORE_FLAGS_SILO_ENABLED
		END
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDeletedAF_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDeletedAF_AfterDel' AND revision = '1.2.2.5')

  insert into GXDBVersions values(6, 'MMDeletedAF_AfterDel',  '1.2.2.5', 'MMDeletedAF_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

