

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDataPath_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDataPath_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDataPath_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDataPath_AfterIns]
  delete from GXDBVersions where name = 'MMDataPath_AfterIns' and type = 6
END
GO

 GO
 SET QUOTED_IDENTIFIER ON
 GO
	CREATE TRIGGER MMDataPath_AfterIns
 	ON MMDataPath
	AFTER INSERT
	AS
 BEGIN
 	IF @@ROWCOUNT = 0 RETURN
		SET NOCOUNT ON
 	IF EXISTS(SELECT 1 FROM Inserted WHERE (Flag & 32) > 0)
		BEGIN
			UPDATE MMDataPath SET Flag = (I.Flag & ~32)
			FROM MMDataPath DP INNER JOIN Inserted I ON DP.DataPathId = I.DataPathId
			RETURN
		END
		DECLARE @l_dedupeFlags INTEGER
		DECLARE @l_dataPathFlags INTEGER

		IF OBJECT_ID('tempdb..#storagePolicies') IS NOT NULL
			DROP TABLE #storagePolicies

		-- Temp table to hold storage policies that have the inserted datapath's CopyId as defaultCopy or defaultSnapCopy
		CREATE TABLE #storagePolicies
		(
			archGroupId INT PRIMARY KEY
		)

		IF OBJECT_ID('tempdb..#clientsInSmartTopo') IS NOT NULL
			DROP TABLE #clientsInSmartTopo

		-- Temp Table to hold clients part of smart topologies and corresponding proxy groups if the topology is a Via-Proxy one.
		CREATE TABLE #clientsInSmartTopo
		(
			clientId INT,
			proxyGroupId INT
		)

		SELECT @l_dedupeFlags = C.dedupeFlags, @l_dataPathFlags = I.Flag
		FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
		WHERE  (I.Flag & 8) = 0 AND (C.dedupeFlags & 268435456) <> 0
		IF  @l_dedupeFlags IS NOT NULL AND (@l_dedupeFlags & 268435456) <> 0
		AND @l_dataPathFlags IS NOT NULL AND (@l_dataPathFlags & 8) = 0
		BEGIN
			INSERT INTO MMDataPath
			SELECT	C.id, I.DrivePoolId, I.HostClientId, I.Flag, I.SpareGroupId,
					I.ReadinessFlag, I.Priority, I.IsHardwareCompressed,
					I.ChunkSizeMB, I.FlushBlockSizeKB, I.UseHardwareEncryption
			FROM	Inserted I
					INNER JOIN archGroupCopy C_GDSP ON I.CopyId = C_GDSP.id AND (C_GDSP.dedupeFlags & 268435456) <> 0
					INNER JOIN archCopyToGlobalPolicy GAGP ON C_GDSP.archGroupId = GAGP.globalPolicyId
					INNER JOIN archGroupCopy C	ON C.id = GAGP.copyId
					LEFT OUTER JOIN MMDataPath D ON D.CopyId = C.id AND D.DrivePoolId = I.DrivePoolId AND D.HostClientId = I.HostClientId AND D.SpareGroupId = I.SpareGroupId
			WHERE	D.CopyId IS NULL
		END
		DECLARE @l_extendedFlags BIGINT
		SELECT @l_extendedFlags = C.extendedFlags
		FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
		IF @l_extendedFlags IS NOT NULL AND (@l_extendedFlags & (1 | 4096) > 0) /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG , CVA_GLOBAL_STORAGE_POLICY_FLAG*/
		BEGIN
			INSERT INTO MMDataPath
			SELECT C.id, I.DrivePoolId, I.HostClientId, I.Flag, I.SpareGroupId,
				I.ReadinessFlag, I.Priority, I.IsHardwareCompressed,
				I.ChunkSizeMB, I.FlushBlockSizeKB, I.UseHardwareEncryption
			FROM Inserted I
			INNER JOIN archGroupCopy G ON G.id = I.CopyId AND (G.extendedFlags & (1 | 4096) > 0)/*CVA_GLOBAL_AUXCOPY_POLICY_FLAG ,CVA_GLOBAL_STORAGE_POLICY_FLAG*/
			INNER JOIN archCopyToGlobalPolicy CG ON G.archGroupId = CG.globalPolicyId
			INNER JOIN archGroupCopy C ON C.id = CG.CopyId
			LEFT OUTER JOIN MMDataPath D ON D.CopyId = C.id AND D.DrivePoolId = I.DrivePoolId AND D.HostClientId = I.HostClientId AND D.SpareGroupId = I.SpareGroupId
			WHERE  D.CopyId IS NULL
		END
		DECLARE @l_targetCopyTable TABLE ( copyId INT, targetCopyId INT)

		INSERT @l_targetCopyTable
		SELECT R.copyId, R.targetCopyId
		FROM Inserted I
		INNER JOIN archCopyMediaRefreshProp R
		ON I.CopyId = R.CopyId

		IF EXISTS ( SELECT * FROM @l_targetCopyTable)
		BEGIN
			INSERT INTO MMDataPath
			SELECT	T.targetCopyId, I.DrivePoolId, I.HostClientId, (I.Flag & 7), I.SpareGroupId,
					I.ReadinessFlag, I.Priority, I.IsHardwareCompressed,
					I.ChunkSizeMB, I.FlushBlockSizeKB, I.UseHardwareEncryption
			FROM	Inserted I
					INNER JOIN @l_targetCopyTable T
					ON I.CopyId = T.copyId
					LEFT OUTER JOIN
					(	SELECT DrivePoolId, HostClientId, SpareGroupId
						FROM MMDataPath M, @l_targetCopyTable TT
						WHERE  M.CopyId = TT.targetCopyId ) R
					ON  R.DrivePoolId = I.DrivePoolId AND R.HostClientId = I.HostClientId AND R.SpareGroupId = I.SpareGroupId
			WHERE	R.DrivePoolId IS NULL
		END
		--Set cloud pruner flag for the datapath if it is associated with a cloud MP which is configured to use datapath settings to pick pruner MA and the copy/drive pool combination does not already have a pruner MA
		;WITH DPPicker(DataPathId, randorder)
		AS
		(
			SELECT I.DataPathId, row_number() OVER(partition by I.CopyId, DPOOL.MasterPoolId order by (I.flag & 4/*MMS2_ENABLED_FAILOVER*/) desc, (I.flag & 1/*MMS2_DEFAULT_FAILOVER*/) desc, NEWID()) as randorder
			FROM Inserted I
			INNER JOIN MMDrivePool DPOOL WITH(READUNCOMMITTED) ON I.DrivePoolId = DPOOL.DrivePoolId
			LEFT OUTER JOIN MMDataPath DP ON I.CopyId = DP.CopyId AND DP.DrivePoolId IN (SELECT DrivePoolId FROM MMDrivePool WITH(READUNCOMMITTED) WHERE MasterPoolId = DPOOL.MasterPoolId) AND (DP.flag & 64 > 0) /*MMS2_PREFERRED_CLOUD_PRUNER*/
			INNER JOIN MMMountPath MP WITH(READUNCOMMITTED) ON DPOOL.MasterPoolId = MP.MasterPoolId
			INNER JOIN ArchGroupCopy AGC WITH(READUNCOMMITTED) ON I.CopyId = AGC.id
			WHERE MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ AND (MP.Attribute & 256 > 0) /*MNTPTH_ATTRIB_USE_DATAPATH_SETTINGS_MA_FOR_PRUNING*/
			AND (AGC.dedupeflags & 134217728 = 0 /*CVA_USE_GLOBAL_DEDUP_STORE_FLAG*/)	AND DP.DataPathId IS NULL
		)
		UPDATE DP
		SET DP.flag = DP.flag | 64 /*MMS2_PREFERRED_CLOUD_PRUNER*/
		FROM MMDataPath DP INNER JOIN DPPicker T ON DP.DataPathId = T.DataPathId AND T.randorder = 1

		-- Get the affected SPs : SPs that have the CopyId of the inserted DataPath as their defaultCopy or defaultSnapCopy.
		INSERT INTO #storagePolicies
		SELECT DISTINCT AG.id FROM archGroup AG WITH(READUNCOMMITTED) INNER JOIN INSERTED I ON AG.defaultCopy = I.CopyId OR AG.defaultSnapCopy = I.CopyId
		WHERE AG.flags & ( 256 /* CVA_SP_GLOBAL_DEDUP_FLAG */ | 16384 /* CVA_SP_GLOBAL_AUXCOPY_POLICY_FLAG */ | 8388608 /* CVA_SP_GLOBAL_POLICY_FLAG */ ) = 0
		DECLARE @rowCount INT = @@ROWCOUNT

		IF @rowCount > 0
		BEGIN
			-- Get the SPs that have the affected SPs as their incrSP.
			INSERT INTO #storagePolicies
			SELECT DISTINCT AG.id FROM archGroup AG WITH(READUNCOMMITTED) INNER JOIN #storagePolicies SP on AG.incrSP = SP.archGroupId
			WHERE NOT EXISTS (SELECT 1 FROM #storagePolicies WHERE archGroupId = AG.id)
					AND AG.incrSP > 1

			-- Get the list of clients that have their subclients associated with the SPs. Also, get the proxy groups for these clients.
			-- Select only those clients that are part of a smart topology with 'My Media Agents' or 'My Commserve & Media Agents' mnemonics.
			INSERT INTO #clientsInSmartTopo
			SELECT DISTINCT App.clientId, ISNULL(TopoProxyGroups.groupId, 0) FROM #storagePolicies AG
			INNER JOIN APP_Application App WITH (NOLOCK) ON AG.archGroupId = App.dataArchGrpId OR AG.archGroupId = App.logArchGrpId
			INNER JOIN APP_ClientGroupAssoc ACGA WITH (NOLOCK) ON App.clientId = ACGA.clientId
			INNER JOIN APP_FirewallTopologyAssoc TopoInternalAndExternal WITH (NOLOCK) ON ACGA.clientGroupId = TopoInternalAndExternal.groupId AND TopoInternalAndExternal.fwGroupType IN (1,2)
			INNER JOIN APP_FirewallTopologyAssoc Mnemonic WITH (NOLOCK) ON Mnemonic.topologyId = TopoInternalAndExternal.topologyId AND Mnemonic.fwGroupType IN (1,2) AND Mnemonic.groupId IN (-2,-3)
			INNER JOIN APP_FirewallTopology Topology WITH (NOLOCK) ON Topology.topologyId = TopoInternalAndExternal.topologyId AND Topology.flag & 1 = 1
			LEFT JOIN APP_FirewallTopologyAssoc TopoProxyGroups WITH(READUNCOMMITTED) ON Topology.topologyId = TopoProxyGroups.groupId AND TopoProxyGroups.fwGroupType = 3

			DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
			-- Push to clients, MAs and also the proxies
			INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
			SELECT clientId, -1, 5 /* WORK_TOKEN_NETWORK */, '', @currentTime, 0, 0, 0 FROM
			(
				-- Clients
				SELECT clientId FROM #clientsInSmartTopo
				UNION
				-- Media Agents
				SELECT DrivePool.ClientId FROM INSERTED I
				INNER JOIN MMDrivePool DrivePool WITH (NOLOCK) ON I.DrivePoolId = DrivePool.DrivePoolId
				UNION
				-- Proxy clients
				SELECT ACGA.clientId FROM APP_ClientGroupAssoc ACGA WITH (NOLOCK) INNER JOIN #clientsInSmartTopo ClientsInSmartTopo ON ACGA.clientGroupId = ClientsInSmartTopo.proxyGroupId
			)PushClientList(clientId)
		END

		IF OBJECT_ID('tempdb..#storagePolicies') IS NOT NULL
			DROP TABLE #storagePolicies

		IF OBJECT_ID('tempdb..#clientsInSmartTopo') IS NOT NULL
			DROP TABLE #clientsInSmartTopo
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDataPath_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDataPath_AfterIns' AND revision = '1.10.34.9.20.1')

  insert into GXDBVersions values(6, 'MMDataPath_AfterIns',  '1.10.34.9.20.1', 'MMDataPath_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

