

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMDataPath_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMDataPath_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMDataPath_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMDataPath_AfterDel]
  delete from GXDBVersions where name = 'MMDataPath_AfterDel' and type = 6
END
GO

 GO
 SET QUOTED_IDENTIFIER ON
 GO
	CREATE TRIGGER MMDataPath_AfterDel
 	ON MMDataPath
	AFTER DELETE
	AS
 BEGIN
 	IF @@ROWCOUNT = 0 RETURN
		SET NOCOUNT ON
		DECLARE @l_dedupeFlags INTEGER
		DECLARE @l_dataPathFlags INTEGER

		IF OBJECT_ID('tempdb..#storagePolicies') IS NOT NULL
			DROP TABLE #storagePolicies

		-- Temp table to hold storage policies that have the deleted datapath's CopyId as defaultCopy or defaultSnapCopy
		CREATE TABLE #storagePolicies
		(
			archGroupId INT PRIMARY KEY
		)

		IF OBJECT_ID('tempdb..#clientsInSmartTopo') IS NOT NULL
			DROP TABLE #clientsInSmartTopo

		-- Temp Table to hold clients part of smart topologies and corresponding proxy groups if the topology is a Via-Proxy one.
		CREATE TABLE #clientsInSmartTopo
		(
			clientId INT,
			proxyGroupId INT
		)

		SELECT @l_dedupeFlags = C.dedupeFlags, @l_dataPathFlags = D.Flag
		FROM Deleted D INNER JOIN archGroupCopy C ON D.CopyId = C.id
		WHERE  (D.Flag & 8) = 0 AND (C.dedupeFlags & 268435456) <> 0
		IF  @l_dedupeFlags IS NOT NULL AND (@l_dedupeFlags & 268435456) <> 0
		AND @l_dataPathFlags IS NOT NULL AND (@l_dataPathFlags & 8) = 0
		BEGIN
			UPDATE	MMMediaGroup
			SET 	DrivePoolId 		= DC.DrivePoolId,
					SpareGroupId 		= DC.SpareGroupId,
					DesiredMediaTypeId 	= DT.DefaultMediaTypeId,
					RecordingFormatId 	= RFMT.RecordingFormatId,
					DataPathId 			= DC.DataPathId
			FROM	MMMediaGroup MG
					INNER JOIN archStream S ON MG.MediaGroupId = S.mediaGroupId
					INNER JOIN (SELECT P.CopyId, P.DataPathId
								FROM	Deleted D
										INNER JOIN archGroupCopy GAGC ON D.CopyId = GAGC.id AND (GAGC.dedupeFlags & 268435456) <> 0
										INNER JOIN MMDataPath P
												ON P.DrivePoolId  = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
										INNER JOIN archCopyToGlobalPolicy GAGP ON GAGC.archGroupId = GAGP.globalPolicyId
										INNER JOIN archGroupCopy C
												ON P.CopyId = C.id AND GAGP.copyId = C.id AND (C.dedupeFlags & 134217728) <> 0
								WHERE	(D.Flag & 8) = 0
								) T ON S.archGroupCopyId = T.CopyId AND MG.DataPathId = T.DataPathId
					INNER JOIN MMDataPath DC ON T.CopyId = DC.CopyId AND (DC.Flag & 7) = 7,
					MMDriveType DT,
					MMRecFmtMedTyp RFMT
			WHERE	DT.DefaultMediaTypeId = RFMT.MediaTypeId
					AND DT.DriveTypeId IN  (SELECT  DR.DriveTypeId
										FROM 	MMDrive DR INNER JOIN MMDrivePool DP ON DR.MasterPoolId = DP.MasterPoolId
										WHERE	DP.DrivePoolId = DC.DrivePoolId)

			DELETE	MMDataPath
			FROM	Deleted D
					INNER JOIN archGroupCopy GAGC ON D.CopyId = GAGC.id AND (GAGC.dedupeFlags & 268435456) <> 0
					INNER JOIN MMDataPath P ON P.DrivePoolId  = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archCopyToGlobalPolicy GAGP ON GAGC.archGroupId = GAGP.globalPolicyId
					INNER JOIN archGroupCopy C
							ON P.CopyId = C.id AND GAGP.copyId = C.id
			WHERE	(D.Flag & 8) = 0
		END
		DECLARE @l_extendedFlags BIGINT
		SELECT @l_extendedFlags = C.extendedFlags
		FROM Deleted D INNER JOIN archGroupCopy C ON D.CopyId = C.id
		IF @l_extendedFlags IS NOT NULL AND (@l_extendedFlags & (1 | 4096) > 0) /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG , CVA_GLOBAL_STORAGE_POLICY_FLAG*/
		BEGIN
			DELETE MMDataPath
			FROM Deleted D
				INNER JOIN MMDataPath P ON P.DrivePoolId = D.DrivePoolId AND P.HostClientId = D.HostClientId AND P.SpareGroupId = D.SpareGroupId
					INNER JOIN archGroupCopy C ON P.CopyId = C.id
					INNER JOIN archGroupCopy G ON D.CopyId = G.id AND (G.extendedFlags & (1 | 4096) > 0)/*CVA_GLOBAL_AUXCOPY_POLICY_FLAG , CVA_GLOBAL_STORAGE_POLICY_FLAG*/
					INNER JOIN archCopyToGlobalPolicy CG ON G.archGroupId = CG.globalPolicyId AND CG.copyId = C.id
			-- If we were unable to update some copies because they did not have default DP defined by GACP/GSP then pick any DP available.
			UPDATE MMDP
			SET MMDP.Flag = MMDP.Flag | 2 | 1 | 4 -- MMS2_DEFAULT_FAILOVER = 1, MMS2_ACTIVE_FAILOVER = 2, MMS2_ENABLED_FAILOVER  = 4
			            FROM MMDataPath MMDP,
			            ( SELECT DepDP.DataPathId AS DPId, ROW_NUMBER() OVER (PARTITION BY DepDP.CopyId ORDER BY (GlobalDP.Flag & 1) DESC) RowNum
			                FROM MMDataPath DepDP,
			                     MMDataPath GlobalDP,
			                     (
			                        SELECT M.CopyId, MAX(M.Flag & 1) as HasDefault, MIN(G.id) as GlobalCopyId
			                        FROM MMDataPath M, archCopyToGlobalPolicy CG, archGroupCopy G, Deleted D
			                        WHERE M.copyId = CG.copyId AND CG.globalPolicyId = G.archGroupId AND (G.extendedFlags & (1 | 4096) > 0) AND G.id = D.copyId /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG , CVA_GLOBAL_STORAGE_POLICY_FLAG*/
			                        GROUP BY M.CopyId
			                      ) Dep_Copies
			                WHERE DepDP.DrivePoolId = GlobalDP.DrivePoolId AND DepDP.HostClientId = GlobalDP.HostClientId AND DepDP.SpareGroupId = GlobalDP.SpareGroupId
			                AND GlobalDP.copyId = Dep_Copies.GlobalCopyId
			                AND DepDP.CopyId = Dep_Copies.CopyId
			                AND Dep_Copies.HasDefault = 0
			             ) T
			WHERE MMDP.DataPathId = T.DPId AND T.RowNum = 1
		END
		DECLARE @l_targetCopyId INTEGER
		DECLARE @l_DataPathId	INTEGER
		SET		@l_targetCopyId	= 0
		SET		@l_DataPathId	= 0
		SELECT @l_targetCopyId = R.targetCopyId
		FROM Deleted D INNER JOIN archCopyMediaRefreshProp R ON D.CopyId = R.CopyId
		IF @l_targetCopyId > 0
		BEGIN
			UPDATE	MMMediaGroup
			SET 	DrivePoolId 		= DC.DrivePoolId,
					SpareGroupId 		= DC.SpareGroupId,
					DesiredMediaTypeId 	= DT.DefaultMediaTypeId,
					RecordingFormatId 	= RFMT.RecordingFormatId,
					DataPathId 			= DC.DataPathId
			FROM	MMMediaGroup MG
					INNER JOIN archStream S ON MG.MediaGroupId = S.mediaGroupId
					INNER JOIN (SELECT  DP.CopyId, DP.DataPathId
								FROM	Deleted D
										INNER JOIN archCopyMediaRefreshProp R ON D.CopyId = R.CopyId
										INNER JOIN MMDataPath DP ON DP.CopyId = R.targetCopyId AND DP.DrivePoolId = D.DrivePoolId
											AND DP.HostClientId = D.HostClientId AND DP.SpareGroupId = D.SpareGroupId
								)  T ON S.archGroupCopyId = T.CopyId AND MG.DataPathId = T.DataPathId
					INNER JOIN MMDataPath DC ON T.CopyId = DC.CopyId AND (DC.Flag & 7) = 7,
					MMDriveType DT,
					MMRecFmtMedTyp RFMT
			WHERE	DT.DefaultMediaTypeId = RFMT.MediaTypeId
					AND DT.DriveTypeId IN  (SELECT  DR.DriveTypeId
										FROM 	MMDrive DR INNER JOIN MMDrivePool DP ON DR.MasterPoolId = DP.MasterPoolId
										WHERE	DP.DrivePoolId = DC.DrivePoolId)
			DELETE	MMDataPath
			FROM	Deleted D INNER JOIN archCopyMediaRefreshProp R ON D.CopyId = R.CopyId
			WHERE	MMDataPath.CopyId = R.targetCopyId AND MMDataPath.DrivePoolId = D.DrivePoolId
														AND MMDataPath.HostClientId = D.HostClientId AND MMDataPath.SpareGroupId = D.SpareGroupId
		END
  	--Set cloud pruner flag for a new datapath if existing pruner MA
		;WITH DPPicker(DataPathId, randorder)
		AS
		(
			SELECT DP.DataPathId, row_number() OVER(partition by DP.CopyId, DPOOL.MasterPoolId order by (DP.flag & 4 /*MMS2_ENABLED_FAILOVER*/) desc, (DP.flag & 1 /*MMS2_DEFAULT_FAILOVER*/) desc, NEWID()) as randorder
			FROM Deleted D
			INNER JOIN MMDrivePool DPOOL WITH(READUNCOMMITTED) ON D.DrivePoolId = DPOOL.DrivePoolId
			INNER JOIN MMDataPath DP ON D.CopyId = DP.CopyId AND DP.DrivePoolId IN (SELECT DrivePoolId FROM MMDrivePool WITH(READUNCOMMITTED) WHERE MasterPoolId = DPOOL.MasterPoolId)
			INNER JOIN MMMountPath MP WITH(READUNCOMMITTED) ON DPOOL.MasterPoolId = MP.MasterPoolId
			INNER JOIN ArchGroupCopy AGC WITH(READUNCOMMITTED) ON DP.CopyId = AGC.id
			WHERE MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ AND (MP.Attribute & 256 > 0) /*MNTPTH_ATTRIB_USE_DATAPATH_SETTINGS_MA_FOR_PRUNING*/
			AND	(AGC.dedupeflags & 134217728 = 0 /*CVA_USE_GLOBAL_DEDUP_STORE_FLAG*/) AND (D.Flag & 64 > 0) /*MMS2_PREFERRED_CLOUD_PRUNER*/
		)
		UPDATE DP
		SET DP.flag = DP.flag | 64 /*MMS2_PREFERRED_CLOUD_PRUNER*/
		FROM MMDataPath DP INNER JOIN DPPicker T ON DP.DataPathId = T.DataPathId AND T.randorder = 1

		-- Get the affected SPs : SPs that have the CopyId of the deleted DataPath as their defaultCopy or defaultSnapCopy.
		INSERT INTO #storagePolicies
		SELECT DISTINCT AG.id FROM archGroup AG WITH(READUNCOMMITTED) INNER JOIN DELETED D ON AG.defaultCopy = D.CopyId OR AG.defaultSnapCopy = D.CopyId
		WHERE AG.flags & ( 256 /* CVA_SP_GLOBAL_DEDUP_FLAG */ | 16384 /* CVA_SP_GLOBAL_AUXCOPY_POLICY_FLAG */ | 8388608 /* CVA_SP_GLOBAL_POLICY_FLAG */ ) = 0
		DECLARE @rowCount INT = @@ROWCOUNT

		IF @rowCount > 0
		BEGIN
			-- Get the SPs that have the affected SPs as their incrSP.
			INSERT INTO #storagePolicies
			SELECT DISTINCT AG.id FROM archGroup AG WITH(READUNCOMMITTED) INNER JOIN #storagePolicies SP on AG.incrSP = SP.archGroupId
			WHERE NOT EXISTS (SELECT 1 FROM #storagePolicies WHERE archGroupId = AG.id)
					AND AG.incrSP > 1

			-- Get the list of clients that have their subclients associated with the SPs. Also, get the proxy groups for these clients.
			-- Select only those clients that are part of a smart topology with 'My Media Agents' or 'My Commserve & Media Agents' mnemonics.
			INSERT INTO #clientsInSmartTopo
			SELECT DISTINCT App.clientId, ISNULL(TopoProxyGroups.groupId, 0) FROM #storagePolicies AG
			INNER JOIN APP_Application App WITH (NOLOCK) ON AG.archGroupId = App.dataArchGrpId OR AG.archGroupId = App.logArchGrpId
			INNER JOIN APP_ClientGroupAssoc ACGA WITH (NOLOCK) ON App.clientId = ACGA.clientId
			INNER JOIN APP_FirewallTopologyAssoc TopoInternalAndExternal WITH (NOLOCK) ON ACGA.clientGroupId = TopoInternalAndExternal.groupId AND TopoInternalAndExternal.fwGroupType IN (1,2)
			INNER JOIN APP_FirewallTopologyAssoc Mnemonic WITH (NOLOCK) ON Mnemonic.topologyId = TopoInternalAndExternal.topologyId AND Mnemonic.fwGroupType IN (1,2) AND Mnemonic.groupId IN (-2,-3)
			INNER JOIN APP_FirewallTopology Topology WITH (NOLOCK) ON Topology.topologyId = TopoInternalAndExternal.topologyId AND Topology.flag & 1 = 1
			LEFT JOIN APP_FirewallTopologyAssoc TopoProxyGroups WITH(READUNCOMMITTED) ON Topology.topologyId = TopoProxyGroups.groupId AND TopoProxyGroups.fwGroupType = 3

			DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
			-- Push to clients, MAs and also the proxies
			INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
			SELECT clientId, -1, 5 /* WORK_TOKEN_NETWORK */, '', @currentTime, 0, 0, 0 FROM
			(
				-- Clients
				SELECT clientId FROM #clientsInSmartTopo
				UNION
				-- Media Agents
				SELECT DrivePool.ClientId FROM DELETED D
				INNER JOIN MMDrivePool DrivePool WITH (NOLOCK) ON D.DrivePoolId = DrivePool.DrivePoolId
				UNION
				-- Proxy clients
				SELECT ACGA.clientId FROM APP_ClientGroupAssoc ACGA WITH (NOLOCK) INNER JOIN #clientsInSmartTopo ClientsInSmartTopo ON ACGA.clientGroupId = ClientsInSmartTopo.proxyGroupId
			)PushClientList(clientId)
		END

		IF OBJECT_ID('tempdb..#storagePolicies') IS NOT NULL
			DROP TABLE #storagePolicies

		IF OBJECT_ID('tempdb..#clientsInSmartTopo') IS NOT NULL
			DROP TABLE #clientsInSmartTopo
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMDataPath_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMDataPath_AfterDel' AND revision = '1.8.2.9.20.1')

  insert into GXDBVersions values(6, 'MMDataPath_AfterDel',  '1.8.2.9.20.1', 'MMDataPath_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

