

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/MMConfigs_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: MMConfigs_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMConfigs_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[MMConfigs_AfterUpd]
  delete from GXDBVersions where name = 'MMConfigs_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER MMConfigs_AfterUpd
 	ON MMConfigs
	AFTER UPDATE
	AS
	BEGIN
		DECLARE @rowCount INT = @@ROWCOUNT
		IF @rowCount = 0 RETURN			--If no rows updated
		IF (UPDATE(value))
 	BEGIN
 		IF @rowCount > 1 --Cannot update more than one config param in an update statement to prevent accidental updates
 		BEGIN
 			RAISERROR ('Cannot update more than one config param of MMConfigs in an update statement. Failing the transaction.', 16, 1)
 			ROLLBACK
 			RETURN
 		END
			DECLARE	@isEnabled	integer
			SET 		@isEnabled = 0
			SELECT	@isEnabled = value
			FROM		Inserted
			WHERE		name = 'DA_ENABLE_DISABLE_TROUBLESHOOTING'
			--------------------------------------------------------------------
			-- Enable/Disable the troubleshooting triggers only if the value for
			-- DA_ENABLE_DISABLE_TROUBLESHOOTING is updated
			--------------------------------------------------------------------
			IF @@ROWCOUNT != 0
			BEGIN
				IF (@isEnabled = 0)
				BEGIN
					-- Disable trigger on archFile table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFile_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFile
						DISABLE TRIGGER archFile_AfterDel
					END

					-- Disable trigger on archFileCopy table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFileCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFileCopy
						DISABLE TRIGGER archFileCopy_AfterDel
					END

					-- Disable trigger on archChunkMapping table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkMapping_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkMapping
						DISABLE TRIGGER archChunkMapping_AfterDel
					END

					-- Disable trigger on archChunk table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunk_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunk
						DISABLE TRIGGER archChunk_AfterDel
					END
				END
				ELSE
				BEGIN
					-- Enable trigger on archFile table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFile_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFile
						ENABLE TRIGGER archFile_AfterDel
					END

					-- Enable trigger on archFileCopy table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFileCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archFileCopy
						ENABLE TRIGGER archFileCopy_AfterDel
					END

					-- Enable trigger on archChunkMapping table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkMapping_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkMapping
						ENABLE TRIGGER archChunkMapping_AfterDel
					END

					-- Enable trigger on archChunk table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunk_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunk
						ENABLE TRIGGER archChunk_AfterDel
					END
				END
			END
			SET 		@isEnabled = 0
			SELECT	@isEnabled = value
			FROM		Inserted
			WHERE		name = 'AUXCOPY_ENABLE_DISABLE_TROUBLESHOOTING'
			--------------------------------------------------------------------
			-- Enable/Disable the troubleshooting triggers only if the value for
			-- AUXCOPY_ENABLE_DISABLE_TROUBLESHOOTING is updated
			--------------------------------------------------------------------
			IF @@ROWCOUNT != 0
			BEGIN
				IF (@isEnabled = 0)
				BEGIN
					-- Disable trigger on archChunkToCopy table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToCopy
						DISABLE TRIGGER archChunkToCopy_AfterDel
					END

					-- Disable trigger on archChunkToSyncDDB table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToSyncDDB_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToSyncDDB
						DISABLE TRIGGER archChunkToSyncDDB_AfterDel
					END

					-- Disable trigger on archChunkToVerify table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToVerify_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToVerify
						DISABLE TRIGGER archChunkToVerify_AfterDel
					END

					-- Disable trigger on archContentIndexingAF table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archContentIndexingAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archContentIndexingAF
						DISABLE TRIGGER archContentIndexingAF_AfterDel
					END

				END
				ELSE
				BEGIN
					-- Enable trigger on archChunkToCopy table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToCopy_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToCopy
						ENABLE TRIGGER archChunkToCopy_AfterDel
					END

					-- Enable trigger on archChunkToSyncDDB table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToSyncDDB_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToSyncDDB
						ENABLE TRIGGER archChunkToSyncDDB_AfterDel
					END

					-- Enable trigger on archChunkToVerify table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archChunkToVerify_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archChunkToVerify
						ENABLE TRIGGER archChunkToVerify_AfterDel
					END

					-- Enable trigger on archContentIndexingAF table
					IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archContentIndexingAF_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
					BEGIN
						ALTER TABLE archContentIndexingAF
						ENABLE TRIGGER archContentIndexingAF_AfterDel
					END
				END
			END
 	END
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [MMConfigs_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'MMConfigs_AfterUpd' AND revision = '1.2.66.2')

  insert into GXDBVersions values(6, 'MMConfigs_AfterUpd',  '1.2.66.2', 'MMConfigs_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

