

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/LicUsageHistUpdateTrig.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: LicUsageHistUpdateTrig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LicUsageHistUpdateTrig]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[LicUsageHistUpdateTrig]
  delete from GXDBVersions where name = 'LicUsageHistUpdateTrig' and type = 6
END
GO

	CREATE TRIGGER LicUsageHistUpdateTrig ON LicUsage
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		INSERT INTO LicUsageHistory
		SELECT DISTINCT D.ID, D.Name, D.CId,
			D.LicType, D.AppType, D.OpType, D.OpTimeUTC, D.TokensUsed, D.Eval,
			D.ExpiryDateUTC, D.ReleaseId, D.EncryptedField, GETUTCDATE(), D.SimOSID,
			D.Build, D.InstallFlag, D.UserID, D.UsedCapacity
		FROM Inserted AS D
	 	WHERE D.LicType NOT BETWEEN 100000 AND 110000
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [LicUsageHistUpdateTrig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'LicUsageHistUpdateTrig' AND revision = '1.5.274.1')

  insert into GXDBVersions values(6, 'LicUsageHistUpdateTrig',  '1.5.274.1', 'LicUsageHistUpdateTrig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

