

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/LicUsageHistInsertTrig.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: LicUsageHistInsertTrig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LicUsageHistInsertTrig]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[LicUsageHistInsertTrig]
  delete from GXDBVersions where name = 'LicUsageHistInsertTrig' and type = 6
END
GO

	CREATE TRIGGER LicUsageHistInsertTrig ON LicUsage
	AFTER INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		INSERT INTO LicUsageHistory
		SELECT D.ID, D.Name, D.CId,
			D.LicType, D.AppType, D.OpType, D.OpTimeUTC, D.TokensUsed, D.Eval,
			D.ExpiryDateUTC, D.ReleaseId, D.EncryptedField, GETUTCDATE(), D.SimOSID,
			D.Build, D.InstallFlag, D.UserID, D.UsedCapacity
		FROM Inserted AS D
	 	WHERE D.LicType NOT BETWEEN 100000 AND 110000
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [LicUsageHistInsertTrig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'LicUsageHistInsertTrig' AND revision = '1.5.274.1')

  insert into GXDBVersions values(6, 'LicUsageHistInsertTrig',  '1.5.274.1', 'LicUsageHistInsertTrig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

