

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/LicUsageHistDeleteTrig.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: LicUsageHistDeleteTrig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LicUsageHistDeleteTrig]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[LicUsageHistDeleteTrig]
  delete from GXDBVersions where name = 'LicUsageHistDeleteTrig' and type = 6
END
GO

	CREATE TRIGGER LicUsageHistDeleteTrig ON LicUsage
	AFTER DELETE
	AS
	BEGIN
		SET NOCOUNT ON
		INSERT INTO LicUsageHistory
		SELECT DISTINCT D.ID, D.Name, D.CId,
			D.LicType, D.AppType, OpType='Deleted', D.OpTimeUTC, D.TokensUsed, D.Eval,
			D.ExpiryDateUTC, D.ReleaseId, D.EncryptedField, GETUTCDATE(), D.SimOSID,
			D.Build, D.InstallFlag, D.UserID, D.UsedCapacity
		FROM Deleted AS D
	 	WHERE D.LicType NOT BETWEEN 100000 AND 110000
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [LicUsageHistDeleteTrig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'LicUsageHistDeleteTrig' AND revision = '1.8.274.1')

  insert into GXDBVersions values(6, 'LicUsageHistDeleteTrig',  '1.8.274.1', 'LicUsageHistDeleteTrig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

