

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMJobStreamsInsertTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMJobStreamsInsertTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMJobStreamsInsertTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMJobStreamsInsertTrigger]
  delete from GXDBVersions where name = 'JMJobStreamsInsertTrigger' and type = 6
END
GO

	CREATE TRIGGER JMJobStreamsInsertTrigger
	ON JMJobStreams
	AFTER INSERT
	AS
	BEGIN
		SET NOCOUNT ON
		IF EXISTS (select * from JMJobStreamsTemp a, inserted b
				where a.jobId = b.jobId
				and a.streamNum = b.streamNum
				AND a.destStreamNum = b.destStreamNum)

		BEGIN
			UPDATE JMJobStream
			SET unCompBytes = a.unCompBytes,
			    compBytes = a.compBytes,
			    committedUncompBytes = a.committedUncompBytes,
			    committedCompBytes = a.committedCompBytes,
			    throughput = a.throughput,
			    totalToCopy = a.totalToCopy,
			    nwTransBytes = a.nwTransBytes
			FROM JMJobStreamsTemp a, inserted b, JMJobStream c
			WHERE a.jobId = b.jobId and a.streamNum = b.streamNum and a.destStreamNum = b.destStreamNum
			and a.jobId = c.jobId and a.streamNum = c.streamNum and a.destStreamNum = c.destStreamNum
		END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMJobStreamsInsertTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMJobStreamsInsertTrigger' AND revision = '1.1')

  insert into GXDBVersions values(6, 'JMJobStreamsInsertTrigger',  '1.1', 'JMJobStreamsInsertTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

