

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/JMJobDataStats_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: JMJobDataStats_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMJobDataStats_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[JMJobDataStats_AfterUpd]
  delete from GXDBVersions where name = 'JMJobDataStats_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER JMJobDataStats_AfterUpd
	ON JMJobDataStats
	AFTER UPDATE
	AS
	BEGIN
 	IF @@ROWCOUNT = 0 RETURN
 	IF UPDATE(RetentionFlags) OR UPDATE(manualRetentionEndTime) OR UPDATE(Disabled) OR UPDATE(Status)
			AND OBJECT_ID('tempdb.dbo.#GRCDoNotTrackJMJobDataStats') IS NULL
 	BEGIN
 		INSERT INTO JMJobDataStatsTracking (commCellId, jobId, archGrpCopyId, dataType)
 		SELECT I.commCellId, I.jobId, I.archGrpCopyId, I.dataType
 		FROM Inserted I INNER JOIN Deleted D ON I.CommcellId = D.CommcellId AND I.JobId = D.JobId
 			AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
 		WHERE 	(I.Status IN (100,102,103) OR D.Status IN (100, 102, 103))
			AND
			(
				I.RetentionFlags <> D.RetentionFlags
				OR I.manualRetentionEndTime <> D.manualRetentionEndTime
 				OR I.Status <> D.Status
				OR (I.Disabled & 256) <> (D.Disabled & 256)
			)
     /*
 		INSERT INTO GRC2JMJobDataStatsTracking (commCellId, jobId, archGrpCopyId, dataType, currStatus, oldStatus, currDisabled, oldDisabled, modifiedTime)
 		SELECT I.commCellId, I.jobId, I.archGrpCopyId, I.dataType, I.status, D.status, I.disabled, D.disabled, GetUTCDate()
 		FROM Inserted I INNER JOIN Deleted D ON I.CommcellId = D.CommcellId AND I.JobId = D.JobId
 			AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
 		WHERE  I.Status <> D.Status OR ((I.Disabled & 256) <> (D.Disabled & 256))
     */
   IF UPDATE(Status) AND NOT EXISTS(SELECT 1 FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_DISABLE_DATROUBLESHOOTING_DATA_COLLECTION' AND value = 1)
   BEGIN
			INSERT INTO DAJobRetentionInfo (jobId, commcellId, copyId, dataType, archGrpId, appId, appFlags, jobFlags, retainUntil, jobRetainReason, requiredByJobIds, created, modified, infoFlags)
			SELECT I.jobId, I.commcellId, I.archGrpCopyId, I.dataType, I.archGrpId, I.appId, 0, 0, 0, 0, '', dbo.GetUnixTime(GETUTCDATE()), 0, 0
			FROM INSERTED I INNER JOIN DELETED D ON I.JobId = D.JobId AND I.CommcellId = D.CommcellId
			AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
			AND I.status IN (100, 102, 103) AND D.status IN (101, 1000)
			DELETE DAJobRetentionInfo
			FROM DAJobRetentionInfo DAJ INNER JOIN INSERTED I ON DAJ.jobId = I.jobId AND DAJ.commcellId = I.commcellId AND DAJ.copyId = I.archGrpCopyId AND DAJ.dataType = I.dataType
			WHERE I.status = 1000
   END
			IF NOT EXISTS (SELECT * FROM MMConfigs where name = 'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND value = 1) --Ability to disable tracking completely
			BEGIN
				IF object_id('GRCJMJobDataStatsTracking') is not null
				BEGIN
 	  		IF UPDATE(Disabled) OR UPDATE(Status)
						INSERT INTO GRCJMJobDataStatsTracking (commcellId, jobId, copyId, dataType, statusChange, createdTime)
						SELECT I.commCellId, I.jobId, I.archGrpCopyId, I.dataType,
						CASE WHEN I.status = 100 AND D.status <> 100 THEN 1 /*GRC_JOB_STATUS_CHANGE_AVAILABLE*/
						WHEN I.status = 101 AND D.status in (100,102,103,1000) THEN 2 /*GRC_JOB_STATUS_CHANGE_MARKED_RECOPY*/
						WHEN I.status in (102,103) AND D.status = 101 THEN 3 /*GRC_JOB_STATUS_CHANGE_PARTIAL*/ --Is there is a possibiliby of 100 -> partial?
						WHEN I.disabled & 256 > 0 AND I.status <> 1000 THEN 4 /*GRC_JOB_STATUS_CHANGE_MARKED_AGED*/
						WHEN I.status = 1000 THEN 5 /*GRC_JOB_STATUS_CHANGE_MEDIADELETED*/
						ELSE 0 /*GRC_JOB_STATUS_CHANGE_UNKNOWN*/		END,
					  dbo.GetUnixTime(GetUTCDate())
					  FROM INSERTED I INNER JOIN DELETED D ON I.CommcellId = D.CommcellId AND I.JobId = D.JobId
						AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
						AND
						(
						I.Status <> D.Status
						OR (I.Disabled & 256) <> (D.Disabled & 256)
						)
					  WHERE ISNULL((select intVal FROM MMEntityProp where propertyName =  'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND EntityType = 2 AND EntityId = I.archGrpCopyId),0) = 0
					--Ability to disable tracking at copy level
			  IF UPDATE(RetentionFlags) OR UPDATE(manualRetentionEndTime) OR UPDATE(disabled)
					INSERT INTO GRCJMJobDataStatsTracking (commcellId, jobId, copyId, dataType, statusChange, createdTime)
					SELECT I.commCellId, I.jobId, I.archGrpCopyId, I.dataType, 6 /*GRC_JOB_STATUS_CHANGE_MISC*/, dbo.GetUnixTime(GetUTCDate())
					FROM INSERTED I INNER JOIN DELETED D ON I.CommcellId = D.CommcellId AND I.JobId = D.JobId
						AND I.archGrpCopyId = D.archGrpCopyId AND I.dataType = D.dataType
						AND
						(
						I.RetentionFlags <> D.RetentionFlags
						OR ( ((I.Disabled & 256) = (D.Disabled & 256)) AND (I.disabled <> D.disabled) ) --If the change is aged flag it would have been tracked above, do not track again here
						OR I.manualRetentionEndTime <> D.manualRetentionEndTime
						)
					WHERE ISNULL((select intVal FROM MMEntityProp where propertyName =  'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND EntityType = 2 AND EntityId = I.archGrpCopyId),0) = 0
					--Ability to disable tracking at copy level
				END
			END
 	END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [JMJobDataStats_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'JMJobDataStats_AfterUpd' AND revision = '1.6.200.3')

  insert into GXDBVersions values(6, 'JMJobDataStats_AfterUpd',  '1.6.200.3', 'JMJobDataStats_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

