

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBUsageHistoryAftInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBUsageHistoryAftInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBUsageHistoryAftInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBUsageHistoryAftInsTrigger]
  delete from GXDBVersions where name = 'IdxSIDBUsageHistoryAftInsTrigger' and type = 6
END
GO

	CREATE TRIGGER	IdxSIDBUsageHistoryAftInsTrigger
	ON 		IdxSIDBUsageHistory
	AFTER INSERT
	AS
	BEGIN
		DECLARE @CurrentUTCDate	datetime
		DECLARE @DiffSeconds	int
		DECLARE @SIDBStoreId	int
		DECLARE @SubStoreId		int
		DECLARE @CommCellId		int
		DECLARE @DayStart		datetime
		DECLARE @DayStartInt	int
		DECLARE @PrimaryEntries		bigint
		DECLARE @SecondaryEntries   bigint
		DECLARE @AvgQITime		bigint
		DECLARE @AvgQITimeSampleCount	int
		DECLARE @NumOfConnections	int
		DECLARE @ZeroRefCount	int
		DECLARE @ReserveField1	int
		DECLARE @PrimaryDataSize	bigint
		DECLARE @ReserveField3	bigint
		DECLARE @ReserveFieldStr	int
		DECLARE @DataSizeToPrune	bigint
		DECLARE @SizeOccupied		bigint
		DECLARE @DDBManagedSize		bigint
		DECLARE @DeleteChunkCount	int
		SET NOCOUNT ON
		SELECT @SIDBStoreId = SIDBStoreId,
		       @SubStoreId = SubStoreId,
		       @CommCellId = CommCellId,
		       @DayStartInt = dbo.GetUnixTime(dbo.ClientLocalToUTCTime(dbo.GetDayStart(dbo.UTCToClientLocalTime(dbo.GetDateTime(ModifiedTime), 2), 0), 2)),
		       @PrimaryEntries = PrimaryEntries,
		       @SecondaryEntries = SecondaryEntries,
		       @AvgQITime 	= AvgQITime,
		       @AvgQITimeSampleCount	= AvgQITimeSampleCount,
		       @NumOfConnections	= NumOfConnections,
		       @ZeroRefCount	= ZeroRefCount,
		       @ReserveField1	= ReserveField1,
		       @PrimaryDataSize	= PrimaryDataSize,
		       @ReserveField3	= ReserveField3,
		       @ReserveFieldStr	= ReserveFieldStr,
		       @DataSizeToPrune	= DataSizeToPrune,
		       @SizeOccupied	= SizeOccupied,
		       @DDBManagedSize	= DDBManagedSize,
		       @DeleteChunkCount	= DeleteChunkCount
		FROM Inserted I
		WHERE HistoryType = 0
	 	IF ISNULL(@SIDBStoreId, 0) > 0
		BEGIN
			SELECT	TOP 1 @SizeOccupied = DiskUsageMB, @PrimaryDataSize = TotalDataSizeBytes
			FROM	IdxSIDBSubStore SIDB WITH (NOLOCK), IdxCache IC WITH (NOLOCK)
			WHERE	SIDB.SIDBStoreId = @SIDBStoreId
					AND SIDB.SubStoreId = @SubStoreId
					AND SIDB.IdxCacheId = IC.IdxCacheId
			SELECT	@DeleteChunkCount = COUNT(*)
			FROM	MMDeletedAF  WITH (NOLOCK)
			WHERE	SIDBStoreId = @SIDBStoreId
			SELECT	@DDBManagedSize = ISNULL(SUM(CAST(PhysicalBytesMB AS BIGINT)), 0)
			FROM	MMVolume WITH (NOLOCK)
			WHERE	SIDBStoreId = @SIDBStoreId
			UPDATE	IdxSIDBUsageHistory
			SET		SizeOccupied	= @SizeOccupied,
					DeleteChunkCount	= @DeleteChunkCount,
					DDBManagedSize	= @DDBManagedSize,
					PrimaryDataSize = @PrimaryDataSize
			FROM	Inserted I
			WHERE	IdxSIDBUsageHistory.SIDBStoreId 		= I.SIDBStoreId
					AND IdxSIDBUsageHistory.SubStoreId		= I.SubStoreId
					AND IdxSIDBUsageHistory.CommCellId		= I.CommCellId
					AND IdxSIDBUsageHistory.HistoryType 	= 0
					AND IdxSIDBUsageHistory.ModifiedTime	= I.ModifiedTime
			IF NOT EXISTS
				(SELECT *
	 		 	FROM IdxSIDBUsageHistory DH
			 	WHERE DH.SIDBStoreId 		= @SIDBStoreId
					and DH.SubStoreId		= @SubStoreId
					and DH.CommCellId		= @CommCellId
					and DH.HistoryType 		= 1
					and DH.ModifiedTime	    = @DayStartInt)
			BEGIN
			INSERT INTO IdxSIDBUsageHistory
			SELECT	@SIDBStoreId, @SubStoreId, @CommCellId,
				1, @DayStartInt,
				@PrimaryEntries, @SecondaryEntries, @AvgQITime, @AvgQITimeSampleCount,
				@NumOfConnections, @ZeroRefCount,
				@ReserveField1, @PrimaryDataSize, @ReserveField3, @ReserveFieldStr,
				@DataSizeToPrune, @SizeOccupied, @DDBManagedSize, @DeleteChunkCount
		END
		ELSE
		BEGIN
			UPDATE IdxSIDBUsageHistory
			SET AvgQITime = @AvgQITime,
			AvgQITimeSampleCount = @AvgQITimeSampleCount
			WHERE SIDBStoreId = @SIDBStoreId
			AND SubStoreId = @SubStoreId
			AND CommCellId = @CommCellId
			AND HistoryType = 1
			AND ModifiedTime = @DayStartInt -- Update valid recorded with begin time of that day.
			AND AvgQITime = 0 -- Only update for AvgQITime = 0 row. If we have value then leave as is.
			AND @AvgQITime > 0 -- Only update it with a valid value. If zero then leave as is.
		END
		END /*IF ISNULL(@SIDBStoreId, 0) > 0*/
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBUsageHistoryAftInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBUsageHistoryAftInsTrigger' AND revision = '1.7.70.1')

  insert into GXDBVersions values(6, 'IdxSIDBUsageHistoryAftInsTrigger',  '1.7.70.1', 'IdxSIDBUsageHistoryAftInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

