

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBSubStore_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBSubStore_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBSubStore_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBSubStore_AfterUpd]
  delete from GXDBVersions where name = 'IdxSIDBSubStore_AfterUpd' and type = 6
END
GO

	CREATE TRIGGER IdxSIDBSubStore_AfterUpd
		ON IdxSIDBSubStore
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		DECLARE	@l_subStoreId INTEGER
		DECLARE	@l_mainStoreId INTEGER
		DECLARE	@l_mainStoreCCId INTEGER
		DECLARE	@l_minLastSnapTime INTEGER
		DECLARE	@l_lastSnapTime INTEGER
		DECLARE @l_reconSIDBs TABLE (SIDBStoreId INTEGER)

		IF UPDATE (FirstBackupTime)
		BEGIN
			UPDATE	IdxSIDBStore
			SET		FirstBackupTime = INS.FirstBackupTime
			FROM	IdxSIDBStore MAIN INNER JOIN INSERTED INS
					ON MAIN.SIDBStoreId = INS.SIDBStoreId
					AND MAIN.CommCellId = INS.CommCellId
					AND MAIN.FirstBackupTime = -1
		END


		IF UPDATE (Status)
		BEGIN
			UPDATE	IdxSIDBStore
			SET		Status = (SELECT CASE
							WHEN ((SELECT COUNT(*) FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = MAIN.SIDBStoreId and status = 1) > AT.percentCorruptLimit AND AGC.dedupeFlags & 33554432 = 0 AND AGC.dedupeFlags & 8 > 0 AND (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = MAIN.SIDBStoreId) > 1)
							THEN 1
							WHEN ((SELECT COUNT(*) FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = MAIN.SIDBStoreId and status = 1) >= 1 AND AGC.dedupeFlags & 33554432 = 0 AND AGC.dedupeFlags & 8 = 0 AND (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = MAIN.SIDBStoreId) > 1) -- when resiliency is off check for first substore corruption
							THEN 1
							WHEN ((SELECT COUNT(*) FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = MAIN.SIDBStoreId and status = 1) > AT.percentCorruptLimit AND AGC.dedupeFlags & 33554432 = 0 AND (SELECT COUNT(*) FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = MAIN.SIDBStoreId) = 1) -- with only 1 substore
							THEN 1
							WHEN (AGC.dedupeFlags & 33554432 > 0 AND NOT EXISTS (SELECT * FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = MAIN.SIDBStoreId AND status = 0))
							THEN 1
							ELSE 0
								END)
			FROM	IdxSIDBStore MAIN WITH (READUNCOMMITTED) INNER JOIN INSERTED INS
					ON MAIN.SIDBStoreId = INS.SIDBStoreId
					AND MAIN.CommCellId = INS.CommCellId
					INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON ACS.SIDBStoreId = MAIN.SIDBStoreId AND ACS.flags & 4 > 0 --IDX_COPY_DDB_ACTIVE
					INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AGC.id = ACS.copyID
					INNER JOIN archTask AT WITH (READUNCOMMITTED) ON AGC.sealStoreTaskId = AT.id
		END

		IF UPDATE (Version)
		BEGIN
			UPDATE	IdxSIDBStore
			SET		Version = INS.Version
			FROM	IdxSIDBStore MAIN INNER JOIN INSERTED INS
					ON MAIN.SIDBStoreId = INS.SIDBStoreId
					AND MAIN.CommCellId = INS.CommCellId
					AND MAIN.Version = -1
		END

		IF UPDATE (TotalDataSizeBytes)
		BEGIN
			SELECT	@l_mainStoreId = SIDBStoreId, @l_mainStoreCCId = CommCellId, @l_subStoreId = SubStoreId
			FROM	INSERTED
			DECLARE	@TotalDataSizeBytesSum BIGINT

			SELECT	@TotalDataSizeBytesSum = SUM(TotalDataSizeBytes)
			FROM	IdxSIDBSubStore WITH (READUNCOMMITTED)
			WHERE	SIDBStoreId = @l_mainStoreId
					AND CommCellId = @l_mainStoreCCId

			UPDATE	IdxSIDBStore
			SET		TotalDataSizeBytes = @TotalDataSizeBytesSum
			WHERE	SIDBStoreId = @l_mainStoreId
					AND CommCellId = @l_mainStoreCCId
		END

		IF UPDATE (InstancedDataSizeBytes)
		BEGIN
			SELECT	@l_mainStoreId = SIDBStoreId, @l_mainStoreCCId = CommCellId, @l_subStoreId = SubStoreId
			FROM	INSERTED
			DECLARE	@InstancedDataSizeBytesSum BIGINT

			SELECT	@InstancedDataSizeBytesSum = SUM(InstancedDataSizeBytes)
			FROM	IdxSIDBSubStore WITH (READUNCOMMITTED)
			WHERE	SIDBStoreId = @l_mainStoreId
					AND CommCellId = @l_mainStoreCCId

			UPDATE	IdxSIDBStore
			SET		InstancedDataSizeBytes = @InstancedDataSizeBytesSum
			WHERE	SIDBStoreId = @l_mainStoreId
					AND CommCellId = @l_mainStoreCCId
		END

		IF (EXISTS (SELECT * FROM
					inserted a left join deleted b on a.SubStoreId = b.SubStoreId
					where a.LastAccessTime <> b.LastAccessTime
				)
		)
		BEGIN
			if ((select top 1 program_name from master..sysprocesses where spid = @@SPID) NOT LIKE 'MediaManager%')
			BEGIN

				IF object_id('tempdb.dbo.#IdxSIDBSubStore_Process_Details') is not null DROP TABLE #IdxSIDBSubStore_Process_Details
				Create Table #IdxSIDBSubStore_Process_Details
					(
						SPID smallint,
						Status varchar(100),
						Login  varchar(100),
						HostName varchar(100),
						BlkBy varchar(100),
						DBName   varchar(100),
						Command  varchar(8000),
						CPUTime int,
						DiskIO int,
						LastBatch varchar(50),
						ProgramName varchar(1000),
						SPIID int,
						RequestId int
					)


				insert
				into #IdxSIDBSubStore_Process_Details
				exec sp_who2 @@SPID

				 CREATE TABLE #inputbuffer
				 (
				  EventType nvarchar(30),
				  Parameters int,
				  EventInfo nvarchar(4000)
				 )
				 DECLARE @ExecStr varchar(50), @Qry nvarchar(4000)

				 SET @ExecStr = 'DBCC INPUTBUFFER(' + STR(@@SPID) + ')'

				 INSERT INTO #inputbuffer
				 EXEC (@ExecStr)

				 SET @Qry = (SELECT EventInfo FROM #inputbuffer)


				Update #IdxSIDBSubStore_Process_Details
				set Command = @Qry

				if (exists (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB')) AND (OBJECT_ID('HistoryDB..MMTblUpdatesHistory') IS NOT NULL)
				insert into HistoryDB..MMTblUpdatesHistory
					select p.SPID, p.Status, p.Login, p.HostName, p.BlkBy, p.DBName, p.Command, p.CPUTime, p.DiskIO, dbo.getUnixTime(GETUTCDATE()), p.ProgramName, p.SPIID, p.RequestId,c.*
					from #IdxSIDBSubStore_Process_Details p,
					(
					select a.SubStoreId as RowId, a.LastAccessTime as newIntValue, b.LastAccessTime as oldIntValue, '' as newStrValue, '' as oldStrValue, GETUTCDATE() as RunTime, 'IdxSIDBSubStore' as TableName
					from inserted a left join deleted b on a.SubStoreId = b.SubStoreId
						where a.LastAccessTime <> b.LastAccessTime
					) c

				drop table #IdxSIDBSubStore_Process_Details
				drop table #inputbuffer
			END
	END
		IF UPDATE (ClientId)
		BEGIN
			DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
			INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
			SELECT DISTINCT drvp.clientID,-1,5,'',@currentTime,0,0,0
			FROM INSERTED AS subStore INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON ACS.SIDBStoreId = subStore.SIDBStoreId AND ACS.flags & 4 > 0 INNER JOIN archGroupCopy agc WITH (READUNCOMMITTED) ON agc.id = ACS.copyID INNER JOIN MMDataPath dp WITH (READUNCOMMITTED) ON dp.copyId = agc.id JOIN MMDrivePool drvp WITH (READUNCOMMITTED) ON dp.DrivePoolId = drvp.DrivePoolId
			UNION
			SELECT DISTINCT drvp.clientID,-1,5,'',@currentTime,0,0,0
			FROM MMDataPath dp WITH (READUNCOMMITTED) JOIN MMDrivePool drvp WITH (READUNCOMMITTED) ON dp.DrivePoolId = drvp.DrivePoolId,
			(SELECT CASE WHEN agc.sourceCopyId > 0 THEN agc.sourceCopyId ELSE ag.defaultCopy END AS srcCopyId
			FROM INSERTED AS subStore INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON ACS.SIDBStoreId = subStore.SIDBStoreId AND ACS.flags & 4 > 0 INNER JOIN archGroupCopy agc WITH (READUNCOMMITTED) ON agc.id = ACS.copyID INNER JOIN archGroup ag WITH (READUNCOMMITTED) ON ag.id = agc.archGroupId AND agc.id <> ag.defaultCopy) t
			WHERE t.srcCopyId = dp.copyId
			UNION
			SELECT DISTINCT aa.clientID,-1,5,'',@currentTime,0,0,0
			FROM INSERTED AS subStore INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON ACS.SIDBStoreId = subStore.SIDBStoreId AND ACS.flags & 4 > 0 INNER JOIN archGroupCopy agc WITH (READUNCOMMITTED) ON agc.id = ACS.copyID INNER JOIN ArchGroup ag WITH (READUNCOMMITTED) ON ag.defaultCopy = agc.id AND ag.id = agc.archGroupId INNER JOIN APP_Application aa WITH (READUNCOMMITTED) ON aa.dataArchGrpID = ag.id OR aa.logArchGrpID = ag.id
		END

		SET NOCOUNT OFF
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBSubStore_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBSubStore_AfterUpd' AND revision = '1.21.88.4')

  insert into GXDBVersions values(6, 'IdxSIDBSubStore_AfterUpd',  '1.21.88.4', 'IdxSIDBSubStore_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

