

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBSubStoreStateHistoryTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBSubStoreStateHistoryTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBSubStoreStateHistoryTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBSubStoreStateHistoryTrigger]
  delete from GXDBVersions where name = 'IdxSIDBSubStoreStateHistoryTrigger' and type = 6
END
GO

	CREATE TRIGGER	IdxSIDBSubStoreStateHistoryTrigger
	ON 		IdxSIDBSubStoreStateHistory
	INSTEAD OF INSERT
	AS
	BEGIN
		DECLARE @HourStartDate	int
		DECLARE @DiffSeconds	int
		declare @tblSubStore table
		(
		 SIDBStoreId		int,
		 SubStoreId		int,
		 CommCellId		int,
		 SubStoreStatus	int,
		 fallBackSubStoreId int,
		 OfflineEntity int,
		 OfflineReason int,
		 TimeStart	int
		 )

		INSERT INTO @tblSubStore
		SELECT I.SIDBStoreId,
				I.SubStoreId,
				I.CommCellId,
				I.Status,
				I.fallBackSubStoreId,
				I.OfflineEntity,
				I.OfflineReason,
				I.Time
		FROM 	Inserted I
		SET NOCOUNT ON

		SET @HourStartDate = dbo.getUnixTime(dbo.GetHourStart(GetUTCDate()))
		IF 	EXISTS
			(SELECT *
			 FROM IdxSIDBSubStoreStateHistory   IDX, @tblSubStore T
			 WHERE 	    IDX.SIDBStoreId 	= T.SIDBStoreId
				and IDX.SubStoreId 	= T.SubStoreId
				and IDX.CommCellId  = T.CommCellId
				and IDX.Time	 		> @HourStartDate)
		BEGIN
			UPDATE 	IdxSIDBSubStoreStateHistory
			SET	fallBackSubStoreId	= T.fallBackSubStoreId,
				OfflineEntity		= T.OfflineEntity,
				OfflineReason		= T.OfflineReason,
				Status				= T.SubStoreStatus,
				Time				= dbo.getUnixTime(GetUTCDate())
			FROM @tblSubStore T
			WHERE 	    IdxSIDBSubStoreStateHistory.SIDBStoreId 	= T.SIDBStoreId
				and IdxSIDBSubStoreStateHistory.SubStoreId	= T.SubStoreId
				and IdxSIDBSubStoreStateHistory.CommCellId 	= T.CommCellId

			DELETE @tblSubStore
			FROM @tblSubStore T, IdxSIDBSubStoreStateHistory IDX
			WHERE IDX.SIDBStoreId 	= T.SIDBStoreId
				and IDX.SubStoreId 	= T.SubStoreId
				and IDX.CommCellId  = T.CommCellId
				and Time	 		> @HourStartDate
		END


		INSERT INTO IdxSIDBSubStoreStateHistory
		SELECT	T.SIDBStoreId,
			T.SubStoreId, 0,
			T.CommCellId, T.fallBackSubStoreId,
			T.SubStoreStatus, dbo.getUnixTime(GetUTCDate()), T.OfflineEntity, T.OfflineReason, 0, 0
		FROM @tblSubStore T

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBSubStoreStateHistoryTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBSubStoreStateHistoryTrigger' AND revision = '1.2')

  insert into GXDBVersions values(6, 'IdxSIDBSubStoreStateHistoryTrigger',  '1.2', 'IdxSIDBSubStoreStateHistoryTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

