

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/IdxSIDBStore_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: IdxSIDBStore_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IdxSIDBStore_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[IdxSIDBStore_AfterDel]
  delete from GXDBVersions where name = 'IdxSIDBStore_AfterDel' and type = 6
END
GO

	CREATE TRIGGER IdxSIDBStore_AfterDel
 	ON IdxSIDBStore
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		declare		@fromProcessId		integer
		set @fromProcessId = isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		INSERT INTO IdxSIDBStorePruningLogs (SIDBStoreId, SIDBStoreName, SIDBStoreAliasName, commCellId, IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime, MinObjSizeKB, oldestEligibleObjArchiveTime,
					SignatureType, flags, TotalDataSizeBytes, InstancedDataSizeBytes, Status, LastAccessTime, CreatedTime, SealedTime, origCCSIDBStoreId, Version,
					SIDBSnapPath, LastSnapTime, LastRecoveryTime, SealedReason, pruneTime, processId)
		SELECT D.SIDBStoreId, D.SIDBStoreName, D.SIDBStoreAliasName, D.commCellId, D.IdxCacheId, D.IdxAccessPathId, D.ClientId, D.FirstBackupTime, D.MinObjSizeKB, D.oldestEligibleObjArchiveTime,
					D.SignatureType, D.flags, D.TotalDataSizeBytes, D.InstancedDataSizeBytes, D.Status, D.LastAccessTime, D.CreatedTime, D.SealedTime, D.origCCSIDBStoreId, D.Version,
					D.SIDBSnapPath, D.LastSnapTime, D.LastRecoveryTime, D.SealedReason, dbo.GetUnixTime(GETUTCDATE()), @fromProcessId
		FROM Deleted D

		--Delete Group if no other stores are using it
		DELETE 	SG
		FROM	IdxSIDBGroup SG, Deleted D
		WHERE	SG.SIDBGroupId = D.SIDBGroupId
				AND SG.SIDBGroupId > 0
				AND NOT EXISTS(SELECT 1 FROM IdxSIDBStore S WHERE S.SIDBGroupId = SG.SIDBGroupId)


 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [IdxSIDBStore_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'IdxSIDBStore_AfterDel' AND revision = '1.4.208.1')

  insert into GXDBVersions values(6, 'IdxSIDBStore_AfterDel',  '1.4.208.1', 'IdxSIDBStore_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

