SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO

BEGIN
		DECLARE @TriggerNameCursorFlag 	INTEGER
		SET 		@TriggerNameCursorFlag 	= 0
		
		DECLARE	@errorCode	INTEGER
		SET 		@errorCode	= 0
		
		DECLARE	@TriggerName		nvarchar(256)
			
		DECLARE	TriggerNameListCursor CURSOR STATIC FOR
		SELECT	distinct name
		FROM		sysobjects
		WHERE	xtype = 'TR'
			AND	OBJECTPROPERTY(id, N'IsTrigger') = 1
			AND	name NOT LIKE '%_CUSTOMOBJ'
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
			
		SET		@TriggerNameCursorFlag = 1
		OPEN	TriggerNameListCursor
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	
		FETCH	NEXT 
		FROM TriggerNameListCursor
		INTO @TriggerName
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		
		--Drop all Triggers
		WHILE	@@FETCH_STATUS = 0
		BEGIN
				
			IF EXISTS (SELECT * FROM sysobjects where name = @TriggerName AND xtype = 'TR' AND OBJECTPROPERTY(id, N'IsTrigger') = 1) 
			BEGIN
				PRINT '>>> Drop Trigger: ' + @TriggerName + ' <<<'
				EXEC ('DROP TRIGGER [' + @TriggerName + ']')
			END
				
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
					
			IF EXISTS (select * from GXDBVersions where aliasname = @TriggerName AND type = 6)
				DELETE FROM GXDBVersions WHERE aliasname = @TriggerName AND type = 6 
		
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
									
			FETCH	NEXT 
			FROM TriggerNameListCursor
			INTO @TriggerName
	
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @TriggerNameCursorFlag = 1
	BEGIN
			CLOSE				TriggerNameListCursor
			DEALLOCATE	TriggerNameListCursor
	END
END	

RETURN
GO
