

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CNMMLibraryHistoryTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CNMMLibraryHistoryTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMLibraryHistoryTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CNMMLibraryHistoryTrigger]
  delete from GXDBVersions where name = 'CNMMLibraryHistoryTrigger' and type = 6
END
GO

CREATE TRIGGER	CNMMLibraryHistoryTrigger
ON 		MMLibraryHistory
INSTEAD OF INSERT
AS
BEGIN
	DECLARE @HourStartDate	datetime
	DECLARE @DiffSeconds	int
	DECLARE @TimeStart	datetime
	DECLARE @HistoryType	int
	SET NOCOUNT ON
	SELECT @HistoryType=HistoryType, @TimeStart=TimeStart FROM Inserted
	IF @HistoryType = 10
	BEGIN
		SET @HourStartDate = @TimeStart
	END
    ELSE
	BEGIN
		-- Adjust time to begginning of day
		SET @HourStartDate  = GetUTCDate()
	END
	-- Get the HourStart time given a DATETIME
	SET @HourStartDate = dbo.GetHourStart(@HourStartDate)
	UPDATE 	MMLibraryHistory
	SET	NumberOfSoftErrors	= MMLibraryHistory.NumberOfSoftErrors + I.NumberOfSoftErrors,
		NumberOfHardErrors	= MMLibraryHistory.NumberOfHardErrors + I.NumberOfHardErrors,
		NumberOfMediaUsed	= MMLibraryHistory.NumberOfMediaUsed + I.NumberOfMediaUsed,
		NumberOfMediaFreed	= MMLibraryHistory.NumberOfMediaFreed + I.NumberOfMediaFreed,
		DataWritten		= MMLibraryHistory.DataWritten + I.DataWritten,
		DataRead		= MMLibraryHistory.DataRead + I.DataRead,
		NumberOfBackups		= MMLibraryHistory.NumberOfBackups + I.NumberOfBackups,
		NumberOfRestores	= MMLibraryHistory.NumberOfRestores + I.NumberOfRestores,
		CapacityFreedMB	= MMLibraryHistory.CapacityFreedMB + I.CapacityFreedMB,
		Modified		= GetUTCDate()
	FROM 	Inserted I
	WHERE 	    MMLibraryHistory.LibraryID 	= I.LibraryID
		and MMLibraryHistory.HistoryType	= 1
		and MMLibraryHistory.TimeStart 	= @HourStartDate
	INSERT INTO MMLibraryHistory
	SELECT	LibraryID,
		1, @HourStartDate,
		NumberOfSoftErrors, NumberOfHardErrors,
		NumberOfMediaUsed, NumberOfMediaFreed, DataWritten, DataRead,
		NumberOfBackups, NumberOfRestores, CapacityFreedMB,
		Modified = GetUTCDate(),
-- QNet 5.9 - Version 3,  QNet 6.1 - Version 4
		4
	FROM 	Inserted I
	WHERE 	NOT EXISTS
		(SELECT *
	 		FROM MMLibraryHistory MH WITH (READUNCOMMITTED)
			WHERE 	    MH.LibraryID 	= I.LibraryID
			and HistoryType 	= 1
			and TimeStart 		= @HourStartDate)
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CNMMLibraryHistoryTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CNMMLibraryHistoryTrigger' AND revision = '1.20.210.1')

  insert into GXDBVersions values(6, 'CNMMLibraryHistoryTrigger',  '1.20.210.1', 'CNMMLibraryHistoryTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

