

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CNMMDriveHistoryTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CNMMDriveHistoryTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNMMDriveHistoryTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CNMMDriveHistoryTrigger]
  delete from GXDBVersions where name = 'CNMMDriveHistoryTrigger' and type = 6
END
GO

	CREATE TRIGGER	CNMMDriveHistoryTrigger
	ON 		MMDriveHistory
	INSTEAD OF INSERT
	AS
	BEGIN
		DECLARE @CurrentUTCDate	datetime
		DECLARE @DiffSeconds	int
		DECLARE @DriveID  int
		DECLARE @ClientID  int
		DECLARE @TimeStart  datetime
		DECLARE @DataWritten int
		DECLARE @DataRead    int
		DECLARE @NumberOfMounts	int
		DECLARE @NumberOfCleans	int
		DECLARE @NumberOfSoftErrors	int
		DECLARE @NumberOfHardErrors	int
		DECLARE @DataWriteDurationSec int
		DECLARE @DataReadDurationSec	int
		DECLARE @NumberOfBackups	int
		DECLARE @NumberOfRestores	int
		DECLARE @KeepMagInfoHourlyOnly	int
		SET NOCOUNT ON
       SELECT    @CurrentUTCDate = (CASE ClientID WHEN  0 THEN TimeStart ELSE GetUTCDate() END )
       FROM Inserted
		SELECT @DriveID = DriveID,
		       @ClientID = ClientID,
		       @TimeStart = CASE WHEN I.DataWriteDurationSec > 0 THEN dbo.GetHourStart(dateadd(second, -I.DataWriteDurationSec, @CurrentUTCDate))
									WHEN I.DataReadDurationSec > 0 THEN dbo.GetHourStart(dateadd(second, -I.DataReadDurationSec, @CurrentUTCDate))
									ELSE dbo.GetHourStart(@CurrentUTCDate)
								  END,
		       @DataWritten = DataWritten,
		       @DataRead = DataRead,
		       @NumberOfMounts 	= NumberOfMounts,
		       @NumberOfCleans	= NumberOfCleans,
		       @NumberOfSoftErrors	= NumberOfSoftErrors,
		       @NumberOfHardErrors	= NumberOfHardErrors,
		       @DataWriteDurationSec	= DataWriteDurationSec,
		       @DataReadDurationSec	= DataReadDurationSec,
		       @NumberOfBackups	= NumberOfBackups,
		       @NumberOfRestores	= NumberOfRestores,
		       @KeepMagInfoHourlyOnly = KeepMagInfoHourlyOnly
		FROM Inserted I
		IF EXISTS
			(SELECT *
	 		 FROM MMDriveHistory DH
			 WHERE DH.DriveID 		= @DriveID
				and DH.ClientId		= @ClientId
				and DH.HistoryType 	= 1
				and DH.TimeStart 	   = @TimeStart)
		BEGIN
			UPDATE 	MMDriveHistory
			SET	NumberOfMounts		= MMDriveHistory.NumberOfMounts + @NumberOfMounts,
				NumberOfCleans		= MMDriveHistory.NumberOfCleans + @NumberOfCleans,
				NumberOfSoftErrors	= MMDriveHistory.NumberOfSoftErrors + @NumberOfSoftErrors,
				NumberOfHardErrors	= MMDriveHistory.NumberOfHardErrors + @NumberOfHardErrors,
				DataWritten		= MMDriveHistory.DataWritten + @DataWritten,
				DataRead		= MMDriveHistory.DataRead + @DataRead,
				DataWriteDurationSec	= MMDriveHistory.DataWriteDurationSec + @DataWriteDurationSec,
				DataReadDurationSec	= MMDriveHistory.DataReadDurationSec + @DataReadDurationSec,
				NumberOfBackups		= MMDriveHistory.NumberOfBackups + @NumberOfBackups,
				NumberOfRestores	= MMDriveHistory.NumberOfRestores + @NumberOfRestores,
				Modified		= GetUTCDate()
			WHERE 	    MMDriveHistory.DriveID 		= @DriveID
				and MMDriveHistory.ClientId 		= @ClientId
				and MMDriveHistory.HistoryType	= 1
				and MMDriveHistory.TimeStart 		= @TimeStart
		END
		ELSE
		BEGIN
			INSERT INTO MMDriveHistory
			SELECT	@DriveID, @ClientId,
				1, HourStartDate = @TimeStart,
				@NumberOfMounts, @NumberOfCleans, @NumberOfSoftErrors, @NumberOfHardErrors,
				@DataWritten, @DataRead, @NumberOfBackups, @NumberOfRestores,
				Modified = GetUTCDate(), @DataWriteDurationSec, @DataReadDurationSec,
				15, @KeepMagInfoHourlyOnly
		END
		INSERT INTO MMDriveHistory
		SELECT	@DriveID, @ClientId,
			2, @CurrentUTCDate,
			0, 0, 0, 0,
			@DataWritten, @DataRead, 0, 0,
			Modified = GetUTCDate(), @DataWriteDurationSec, @DataReadDurationSec,
			15, @KeepMagInfoHourlyOnly
		WHERE	(@DataWritten > 0 OR @Dataread > 0)
		AND 	NOT EXISTS
			(SELECT *
	 		 FROM MMDriveHistory DH
			 WHERE 	    DH.DriveID 		= @DriveID
				and DH.ClientId		= @ClientId
				and DH.HistoryType 	= 2
				and DH.TimeStart 	= @CurrentUTCDate)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CNMMDriveHistoryTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CNMMDriveHistoryTrigger' AND revision = '1.23')

  insert into GXDBVersions values(6, 'CNMMDriveHistoryTrigger',  '1.23', 'CNMMDriveHistoryTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

