

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CNDriveCoreTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CNDriveCoreTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CNDriveCoreTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CNDriveCoreTrigger]
  delete from GXDBVersions where name = 'CNDriveCoreTrigger' and type = 6
END
GO

	CREATE TRIGGER CNDriveCoreTrigger
 ON MMDrive
	AFTER UPDATE
	AS
 IF @@ROWCOUNT = 0 RETURN
	SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()
 IF UPDATE(drivenumber)
 BEGIN


 		INSERT INTO MMDriveUpdateTracker
 		select I.DriveId,
 		D.drivenumber, I.drivenumber,
 		@CurrentUTCDate
 		FROM Deleted D, Inserted I
 		WHERE D.driveid = I.driveid
 		AND (D.drivenumber <> I.drivenumber)

 		IF (@@ROWCOUNT > 0)
 		BEGIN
 			UPDATE MMDrive
 			SET DriveNumber = D.DriveNumber
 			FROM Deleted D
 			WHERE D.DriveId = MMDrive.DriveId
 		END
 END
 IF UPDATE(DriveSoftState) OR UPDATE(DriveEnabled) OR UPDATE(DriveBroken) OR UPDATE(CleaningRequired)
 BEGIN

 		INSERT INTO MMDriveStateHistory
 		SELECT I.DriveId, 0,
 		State = (I.DriveSoftState & I.DriveEnabled & ~I.CleaningRequired & ~I.DriveBroken),
 		@CurrentUTCDate,
 		I.OfflineReason
 		FROM Inserted I, Deleted D
 		WHERE	(I.DriveID = D.DriveID)
 				AND (I.DriveSoftState <> D.DriveSoftState OR I.DriveEnabled <> D.DriveEnabled OR I.CleaningRequired <> D.CleaningRequired OR I.DriveBroken <> D.DriveBroken)

 END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CNDriveCoreTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CNDriveCoreTrigger' AND revision = '1.21')

  insert into GXDBVersions values(6, 'CNDriveCoreTrigger',  '1.21', 'CNDriveCoreTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

