

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/CCRClientToClientOnDelete.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: CCRClientToClientOnDelete'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CCRClientToClientOnDelete]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[CCRClientToClientOnDelete]
  delete from GXDBVersions where name = 'CCRClientToClientOnDelete' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER CCRClientToClientOnDelete
ON CCRClientToClient
AFTER DELETE
AS
BEGIN
	IF @@ROWCOUNT = 0 RETURN
	SET NOCOUNT ON
	DECLARE @nowTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	DECLARE @lastOfflineTimePropName NVARCHAR(1024) = N'Last offline time'
	UPDATE cp
	SET attrVal = del.lastOfflineTime
	FROM APP_ClientProp cp
	JOIN DELETED del ON del.fromClientId = 2 AND cp.attrName = @lastOfflineTimePropName AND cp.modified = 0 AND cp.componentNameId = del.ToClientId
	INSERT INTO APP_ClientProp
	(componentNameId, attrName, attrType, attrVal, created, modified)
	SELECT del.ToClientId, @lastOfflineTimePropName, 7, del.lastOfflineTime, @nowTime, 0
	FROM DELETED del
	JOIN App_Client c (NOLOCK) ON del.ToClientId = c.id
	LEFT JOIN APP_ClientProp cp (NOLOCK) ON cp.attrName = @lastOfflineTimePropName AND cp.modified = 0 AND cp.componentNameId = del.ToClientId
	WHERE del.fromClientId = 2 AND cp.componentNameId IS NULL
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [CCRClientToClientOnDelete]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'CCRClientToClientOnDelete' AND revision = '1.1.2.1.14.1')

  insert into GXDBVersions values(6, 'CCRClientToClientOnDelete',  '1.1.2.1.14.1', 'CCRClientToClientOnDelete', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

