

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BlrBootVM_AfterDel.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BlrBootVM_AfterDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BlrBootVM_AfterDel]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BlrBootVM_AfterDel]
  delete from GXDBVersions where name = 'BlrBootVM_AfterDel' and type = 6
END
GO

	CREATE TRIGGER BlrBootVM_AfterDel
 	ON BlrBootVM
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN
		--
		declare	@fromProcessId		integer
		set 		@fromProcessId = 	isnull((select top 1 hostprocess from master..sysprocesses where spid = @@SPID),0)
		declare		@currentTime		integer = dbo.GetUnixTime(GETUTCDATE())
		--
		IF ((EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB')) AND (OBJECT_ID('HistoryDB..BlrBootVMHistory') IS NOT NULL))
		BEGIN
			INSERT INTO HistoryDB..BlrBootVMHistory (id, bootType, pairId, name, uuid,	creationTime, deletionTime, bestBefore, seqNum, statusCode, statusMessage, eventId, processId)
			SELECT D.id, D.bootType, D.pairId, D.name, D.uuid, D.creationTime, (CASE WHEN D.deletionTime = 0 THEN @currentTime ELSE D.deletionTime END), D.bestBefore, D.seqNum, D.statusCode, D.statusMessage, D.eventId, @fromProcessId
			FROM Deleted D
		END
 	--
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BlrBootVM_AfterDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BlrBootVM_AfterDel' AND revision = '1.1.2.1')

  insert into GXDBVersions values(6, 'BlrBootVM_AfterDel',  '1.1.2.1', 'BlrBootVM_AfterDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

