

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLEntityMembersInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLEntityMembersInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLEntityMembersInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLEntityMembersInsTrigger]
  delete from GXDBVersions where name = 'BLEntityMembersInsTrigger' and type = 6
END
GO

	CREATE TRIGGER BLEntityMembersInsTrigger
	ON BLEntityMembers
	INSTEAD OF INSERT
	AS
	BEGIN
		SET NOCOUNT ON

		DECLARE @CreatedTime datetime
		DECLARE @DeletedTime datetime

		SET @CreatedTime = GetUTCDate()
		SET @DeletedTime = dbo.GetDateTime(0)

		UPDATE BLEntityMembersHistory
		SET DeletedTime = @CreatedTime,
			ModifiedTime = @CreatedTime,
			LogDeleted = 1
		FROM INSERTED AS I, BLEntityMembersHistory AS B1
		WHERE EntityGUID = B1.EntityGUID
			AND (B1.ClientID IN (I.ClientID, 0)
				OR I.ClientID = 0)
			AND (B1.AppTypeID IN (I.AppTypeID, 0)
				OR I.AppTypeID = 0)
			AND (B1.InstanceID IN (I.InstanceID, 0)
				OR I.InstanceID = 0)
			AND (B1.BackupSetID IN (I.BackupSetID, 0)
				OR I.BackupSetID = 0)
			AND (B1.AppID IN (I.AppID, 0)
				OR I.AppID = 0)
			AND B1.LogDeleted = 0
			AND NOT EXISTS
			(
				SELECT *
				FROM INSERTED AS I1, BLEntityMembersHistory AS B2
				WHERE 	B2.EntityID = I1.EntityID
					AND B2.ClientID = I1.ClientID
					AND B2.AppTypeID = I1.AppTypeID
					AND B2.InstanceID = I1.InstanceID
					AND B2.BackupSetID = I1.BackupSetID
					AND B2.AppID = I1.AppID
					AND B2.LogDeleted = 0
			)

		DELETE BLEntityMembers
		FROM INSERTED AS I, BLEntityMembers AS B1
		WHERE (B1.ClientID IN (I.ClientID, 0)
				OR I.ClientID = 0)
			AND (B1.AppTypeID IN (I.AppTypeID, 0)
				OR I.AppTypeID = 0)
			AND (B1.InstanceID IN (I.InstanceID, 0)
				OR I.InstanceID = 0)
			AND (B1.BackupSetID IN (I.BackupSetID, 0)
				OR I.BackupSetID = 0)
			AND (B1.AppID IN (I.AppID, 0)
				OR I.AppID = 0)
			AND NOT EXISTS
			(
				SELECT *
				FROM INSERTED AS I1, BLEntityMembersHistory AS B2
				WHERE 	B2.EntityID = I1.EntityID
					AND B2.ClientID = I1.ClientID
					AND B2.AppTypeID = I1.AppTypeID
					AND B2.InstanceID = I1.InstanceID
					AND B2.BackupSetID = I1.BackupSetID
					AND B2.AppID = I1.AppID
					AND B2.LogDeleted = 0
			)

		-- EntityID = 0 is invalid association, EntityID 1 is NoAssociation
		-- If it is one of these two then just the logical deletion above is sufficient.
		-- Add new Association into the table.
		INSERT INTO BLEntityMembers
		SELECT I.EntityID, I.AssocType, I.ClientID, I.AppTypeID,
			I.InstanceID, I.BackupSetID, I.AppID
		FROM INSERTED AS I
		WHERE I.EntityID NOT IN (0, 1)
		AND NOT EXISTS
		(
			SELECT *
			FROM INSERTED AS I1, BLEntityMembersHistory AS B2
			WHERE 	B2.EntityID = I1.EntityID
				AND B2.ClientID = I1.ClientID
				AND B2.AppTypeID = I1.AppTypeID
				AND B2.InstanceID = I1.InstanceID
				AND B2.BackupSetID = I1.BackupSetID
				AND B2.AppID = I1.AppID
				AND B2.LogDeleted = 0
		)

		-- Add new Association into the table.
		INSERT INTO BLEntityMembersHistory
		SELECT I.EntityID, BLE.EntityGUID, I.AssocType, I.ClientID, I.AppTypeID,
			I.InstanceID, I.BackupSetID,
			0, -- Log Deleted
			GetUTCDate(),
			dbo.GetDateTime(0),
			GetUTCDate(), I.AppID
		FROM INSERTED AS I, BLEntity AS BLE
		WHERE I.EntityID NOT IN (0, 1)
			AND BLE.EntityID = I.EntityID
			AND NOT EXISTS
			(
				SELECT *
				FROM INSERTED AS I1, BLEntityMembersHistory AS B2
				WHERE 	B2.EntityID = I1.EntityID
					AND B2.ClientID = I1.ClientID
					AND B2.AppTypeID = I1.AppTypeID
					AND B2.InstanceID = I1.InstanceID
					AND B2.BackupSetID = I1.BackupSetID
					AND B2.AppID = I1.AppID
					AND B2.LogDeleted = 0
			)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLEntityMembersInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLEntityMembersInsTrigger' AND revision = '1.10')

  insert into GXDBVersions values(6, 'BLEntityMembersInsTrigger',  '1.10', 'BLEntityMembersInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

