

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/BLEntityMembersDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: BLEntityMembersDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BLEntityMembersDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[BLEntityMembersDelTrigger]
  delete from GXDBVersions where name = 'BLEntityMembersDelTrigger' and type = 6
END
GO

	CREATE TRIGGER BLEntityMembersDelTrigger
	ON BLEntityMembers
 INSTEAD OF DELETE
 AS
	BEGIN
		SET NOCOUNT ON
		UPDATE BLEntityMembersHistory
		SET BLEntityMembersHistory.DeletedTime = GetUTCDate(),
			BLEntityMembersHistory.ModifiedTime = GetUTCDate(),
			BLEntityMembersHistory.LogDeleted = 1
		FROM Deleted D
			INNER JOIN BLEntity as BLE
				ON BLE.EntityID = D.EntityID
		WHERE BLEntityMembersHistory.EntityGUID = BLE.EntityGUID
			AND BLEntityMembersHistory.ClientID IN (D.ClientID, 0)
			AND BLEntityMembersHistory.AppTypeID IN (D.AppTypeID, 0)
			AND BLEntityMembersHistory.InstanceID IN (D.InstanceID, 0)
			AND BLEntityMembersHistory.BackupSetID IN (D.BackupSetID, 0)
			AND BLEntityMembersHistory.AppID IN (D.AppID, 0)
			AND BLEntityMembersHistory.LogDeleted = 0
		DELETE BLEntityMembers
		FROM DELETED D
		WHERE	BLEntityMembers.EntityID = D.EntityID
			AND BLEntityMembers.ClientID = D.ClientID
			AND BLEntityMembers.AppTypeID = D.AppTypeID
			AND BLEntityMembers.InstanceID = D.InstanceID
			AND BLEntityMembers.BackupSetID = D.BackupSetID
			AND BLEntityMembers.AppID = D.AppID
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [BLEntityMembersDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'BLEntityMembersDelTrigger' AND revision = '1.7')

  insert into GXDBVersions values(6, 'BLEntityMembersDelTrigger',  '1.7', 'BLEntityMembersDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

