

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupUpgTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupUpgTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupUpgTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupUpgTrigger]
  delete from GXDBVersions where name = 'ArchGroupUpgTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupUpgTrigger
	ON ArchGroup
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
		IF (UPDATE(defaultSnapCopy))
		BEGIN
			UPDATE	archAgingRule
			SET		retentionDays = T.retentionDays, fullCycles = T.fullCycles, flags = T.flags,
					weekStart = T.weekStart, monthStart = T.monthStart, yearStart = T.yearStart,
					archiverRetDays = T.archiverRetDays, retentionJobs  = T.retentionJobs
			FROM	(SELECT	AGC.id, AR.retentionDays, AR.fullCycles, AR.flags,
							AR.weekStart, AR.monthStart, AR.yearStart, AR.archiverRetDays, AR.retentionJobs
					FROM	INSERTED I
							INNER JOIN archGroupCopy AGC WITH(INDEX(argrcp_idx2)) ON AGC.archGroupId = I.id
							INNER JOIN archAgingRule AR ON AR.copyId = AGC.sourceCopyId
					WHERE	AGC.id <> I.defaultSnapCopy
							AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
					) T
			WHERE	archAgingRule.copyId = T.id
			DELETE	archAgingRuleExtended
			FROM	INSERTED I
					INNER JOIN archGroupCopy AGC WITH(INDEX(argrcp_idx2)) ON AGC.archGroupId = I.id
			WHERE	archAgingRuleExtended.copyId = AGC.id
					AND AGC.id <> I.defaultSnapCopy
					AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
			INSERT	INTO archAgingRuleExtended
			SELECT	AGC.id,	AR.retentionDays, AR.retentionRule, AR.currPeriodBegin, AR.currPeriodEnd,
					AR.prevPeriodBegin, AR.nextPeriodEnd, AR.GraceDays ,AR.EveryXHours
			FROM	INSERTED I
					INNER JOIN archGroupCopy AGC WITH(INDEX(argrcp_idx2)) ON AGC.archGroupId = I.id
					INNER JOIN archAgingRuleExtended AR ON AR.copyId = AGC.sourceCopyId
			WHERE	AGC.id <> I.defaultSnapCopy
					AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
		END
		IF (UPDATE(maxStreams))
			AND EXISTS (SELECT 1 FROM archGroupCopy WITH(READUNCOMMITTED) WHERE id IN (SELECT defaultCopy FROM INSERTED) AND extendedFlags&1/*CVA_GLOBAL_AUXCOPY_POLICY_FLAG*/<>0)
		BEGIN
			UPDATE AGC
			SET AGC.maxStreamNum = I.maxStreams
			FROM archGroupCopy AGC, INSERTED I
			WHERE AGC.destMediaCopyId = I.defaultCopy
		END

		IF UPDATE(defaultCopy) OR UPDATE(defaultSnapCopy) OR UPDATE(incrSP)
		BEGIN

			IF OBJECT_ID('tempdb..#defaultCopies') IS NOT NULL
				DROP TABLE #defaultCopies

			-- Temp Table to hold old and new defaultCopy values for the updated SP.
			CREATE TABLE #defaultCopies
			(
				archGroupId INT,
				defaultCopy INT
			)

			IF OBJECT_ID('tempdb..#defaultSnapCopies') IS NOT NULL
				DROP TABLE #defaultSnapCopies

			-- Temp Table to hold old and new defaultSnapCopy values for the updated SP.
			CREATE TABLE #defaultSnapCopies
			(
				archGroupId INT,
				defaultSnapCopy INT
			)

			IF OBJECT_ID('tempdb..#incrSPs') IS NOT NULL
				DROP TABLE #incrSPs

			-- Temp Table to hold old and new incrSP values for the updated SP.
			CREATE TABLE #incrSPs
			(
				archGroupId INT,
				incrSP INT
			)

			IF OBJECT_ID('tempdb..#relevantSPs') IS NOT NULL
				DROP TABLE #relevantSPs

			-- Temp Table to hold relevant SPs. Relevant SPs are SPs that have their clients part of a smart topology with either 'My Media Agents' or 'My Commserve & Media Agents'
			CREATE TABLE #relevantSPs
			(
				archGroupId INT PRIMARY KEY
			)

			-- Get old and new defaultCopy values.
			INSERT INTO #defaultCopies
			SELECT archGroupId, defaultCopy FROM
			(
				SELECT I.id, D.defaultCopy, I.defaultCopy FROM INSERTED I INNER JOIN DELETED D ON I.id = D.id WHERE I.defaultCopy <> D.defaultCopy
			) ArchGroupOldAndNew (archGroupId, oldDefaultCopy, newDefaultCopy)
			UNPIVOT
			( defaultCopy FOR oldOrNew IN (oldDefaultCopy, newDefaultCopy) ) unpvt

			-- Get old and new defaultSnapCopy values.
			INSERT INTO #defaultSnapCopies
			SELECT archGroupId, defaultSnapCopy FROM
			(
			SELECT I.id, D.defaultSnapCopy, I.defaultSnapCopy FROM INSERTED I INNER JOIN DELETED D ON I.id = D.id WHERE I.defaultSnapCopy <> D.defaultSnapCopy
			) ArchGroupOldAndNew (archGroupId, oldDefaultSnapCopy, newDefaultSnapCopy)
			UNPIVOT
			( defaultSnapCopy FOR oldOrNew IN (oldDefaultSnapCopy, newDefaultSnapCopy) ) unpvt
			WHERE defaultSnapCopy > 0

			-- Get old and new incrSP values.
			INSERT INTO #incrSPs
			SELECT archGroupId, incrSP FROM
			(
			SELECT I.id, D.incrSP, I.incrSP FROM INSERTED I INNER JOIN DELETED D ON I.id = D.id WHERE I.incrSP <> D.incrSP
			) ArchGroupOldAndNew (archGroupId, oldIncrSP, newIncrSP)
			UNPIVOT
			( incrSP FOR oldOrNew IN (oldIncrSP, newIncrSP) ) unpvt
			WHERE incrSP > 1


			INSERT INTO #relevantSPs
			SELECT archGroupId FROM #defaultCopies
			UNION
			SELECT archGroupId FROM #defaultSnapCopies
			UNION
			SELECT archGroupID FROM #incrSPs

			-- Delete SPs that are not relevant, i.e SPs that don't have their associated clients part of any smart topology with 'My Media Agents' or 'My Commserve & Media Agents'.
			DELETE RelevantSPs
			FROM
			#relevantSPs RelevantSPs
			INNER JOIN APP_Application App WITH(READUNCOMMITTED) ON App.dataArchGrpID = RelevantSPs.archGroupId OR App.logArchGrpID = RelevantSPs.archGroupId
			INNER JOIN APP_ClientGroupAssoc ACGA WITH(READUNCOMMITTED) ON App.clientId = ACGA.clientId
			LEFT JOIN
			(
			SELECT AFTA.topologyId, AFTA.fwGroupType, AFTA.groupId FROM APP_FirewallTopologyAssoc AFTA WITH(READUNCOMMITTED)
			INNER JOIN APP_FirewallTopology AFT WITH(READUNCOMMITTED) ON AFTA.topologyId = AFT.topologyId AND AFT.flag & 1 = 1 AND AFTA.fwGroupType IN (1,2) AND AFTA.groupId > 0
			INNER JOIN APP_FirewallTopologyAssoc AFTA1 WITH(READUNCOMMITTED) ON AFTA1.topologyId = AFT.topologyId AND AFTA1.fwGroupType IN (1,2) AND AFTA1.groupId IN (-2,-3)
			) TopoAssoc
			ON ACGA.clientGroupId = TopoAssoc.groupId
			WHERE TopoAssoc.topologyId IS NULL

			IF EXISTS ( SELECT  1 FROM #relevantSPs )
			BEGIN

				-- Get the defaultCopy values of incrSPs.
				INSERT INTO #defaultCopies
				SELECT IncrSPs.incrSP, AG.defaultCopy FROM #incrSPs IncrSPs INNER JOIN archGroup AG WITH(READUNCOMMITTED) ON IncrSPs.incrSP = AG.id

				-- Get the defaultSnapCopy values of incrSPs.
				INSERT INTO #defaultSnapCopies
				SELECT IncrSPs.incrSP, AG.defaultSnapCopy FROM #incrSPs IncrSPs INNER JOIN archGroup AG WITH(READUNCOMMITTED) ON IncrSPs.incrSP = AG.id
				WHERE AG.defaultSnapCopy > 0

				IF OBJECT_ID('tempdb..#incrSPs') IS NOT NULL
					DROP TABLE #incrSPs

				DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
				INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
				SELECT clientId, -1, 5, '', @currentTime, 0, 0, 0 FROM
				(
					-- Push to clients that are associated with the updated storage policies.
					SELECT App.ClientId FROM #relevantSPs RelevantSPs
					INNER JOIN APP_Application App WITH(READUNCOMMITTED) ON RelevantSPs.archGroupId = App.dataArchGrpID OR RelevantSPs.archGroupId = App.logArchGrpID
					UNION
					-- Push to related datapath MAs and DDB MAs
					-- Datapath MAs
					SELECT DrivePool.ClientId FROM
					(SELECT archGroupId, defaultCopy FROM #defaultCopies UNION SELECT archGroupId, defaultSnapCopy FROM #defaultSnapCopies) Copies(archGroupId, copyId)
					INNER JOIN #relevantSPs RelevantSPs ON Copies.archGroupId = RelevantSPs.archGroupId -- Only use relevant SPs : SPs that have their associated clients part of smart topologies.
					INNER JOIN MMDataPath DataPath WITH(READUNCOMMITTED) ON DataPath.CopyId = Copies.copyId
					INNER JOIN MMDrivePool DrivePool WITH(READUNCOMMITTED) ON DataPath.DrivePoolId = DrivePool.DrivePoolId
					UNION
					-- DDB MAs
					SELECT SubStore.clientId FROM #defaultCopies DefaultCopies
					INNER JOIN #relevantSPs RelevantSPs ON DefaultCopies.archGroupId = RelevantSPs.archGroupId -- Only use relevant SPs : SPs that have their associated clients part of smart topologies.
					INNER JOIN archCopySIDBStore ACSStore WITH(READUNCOMMITTED) ON ACSStore.CopyId = DefaultCopies.defaultCopy
					INNER JOIN IdxSIDBSubStore SubStore WITH(READUNCOMMITTED) ON SubStore.SIDBStoreId = ACSStore.SIDBStoreId
				)PushClientList(clientId)

			END

			IF OBJECT_ID('tempdb..#defaultCopies') IS NOT NULL
				DROP TABLE #defaultCopies

			IF OBJECT_ID('tempdb..#defaultSnapCopies') IS NOT NULL
				DROP TABLE #defaultSnapCopies

			IF OBJECT_ID('tempdb..#relevantSPs') IS NOT NULL
				DROP TABLE #relevantSPs

		END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupUpgTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupUpgTrigger' AND revision = '1.11.54.9')

  insert into GXDBVersions values(6, 'ArchGroupUpgTrigger',  '1.11.54.9', 'ArchGroupUpgTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

