

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupCoreTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupCoreTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupCoreTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupCoreTrigger]
  delete from GXDBVersions where name = 'ArchGroupCoreTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupCoreTrigger
 ON archGroup
	AFTER UPDATE
	AS
	SET NOCOUNT ON
	DECLARE @CurrentUTCDate datetime
	SET @CurrentUTCDate = GetUTCDate()
	IF UPDATE (name)
	BEGIN
	      INSERT INTO ArchGroupCoreHistory
	         (ArchGroupId,
	         ArchGroupName,
	         Modified)
		 SELECT
	            ins.id,
	            ins.name,
	            @CurrentUTCDate
	         FROM INSERTED ins
		 WHERE NOT EXISTS
			(SELECT * FROM ArchGroupCoreHistory AH
			 WHERE ins.id = AH.ArchGroupID AND @CurrentUTCDate = AH.Modified)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupCoreTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupCoreTrigger' AND revision = '1.1')

  insert into GXDBVersions values(6, 'ArchGroupCoreTrigger',  '1.1', 'ArchGroupCoreTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

