

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchGroupCopyUpgTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchGroupCopyUpgTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupCopyUpgTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchGroupCopyUpgTrigger]
  delete from GXDBVersions where name = 'ArchGroupCopyUpgTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchGroupCopyUpgTrigger
	ON ArchGroupCopy
	AFTER UPDATE
	AS
	BEGIN
		SET NOCOUNT ON
			--CVA_AUXCOPY_PASSTHRU_ENCRYPT, CVA_AUXCOPY_DECRYPTED_DATA, CVA_AUXCOPY_NETWORK_ONLY_ENCRYPT, CVA_AUXCOPY_REENCRYPT_DATA_FLAG
		declare @encMask int = 1048576 | 2097152 | 4194304 | 8388608
		declare @reencBit int = 8388608 /*CVA_AUXCOPY_REENCRYPT_DATA_FLAG*/
		declare @passThruBit int = 1048576 /*CVA_AUXCOPY_PASSTHRU_ENCRYPT*/
		declare @netOnlyEncBit int = 4194304 /*CVA_AUXCOPY_NETWORK_ONLY_ENCRYPT*/
		declare @storeOnMediaBit int = 131072 /*CVA_STORE_KEY_ON_MEDIA*/
		declare @encryptOnPrimaryExBit int = 262144 /*CVA_ENCRYPT_ON_DEPENDENT_PRIMARY*/
		-- Do not allow CVA_WORM_COPY_FLAG (=16777216) be reset once it is set.
		IF (UPDATE(flags))
		BEGIN
			UPDATE	archGroupCopy
			SET		flags = (archGroupCopy.flags | 16777216)
			FROM	Deleted D
			WHERE	archGroupCopy.id = D.id AND (archGroupCopy.flags & 16777216) = 0 AND (D.flags & 16777216) <> 0
		END
		--1. When override flag is toggled on the dependent copy OR
		--2. When dependent copy is promoted or demoted
		IF (UPDATE(extendedFlags) AND EXISTS (SELECT 1 FROM Inserted AS I, Deleted AS D WHERE I.id = D.id
					AND ((I.extendedFlags & 65536) = 0) AND ((D.extendedFlags & 65536) > 0)))
			OR UPDATE(copy)
		BEGIN
				UPDATE	C
				SET	encType 	= (case when
											(
												AG.defaultCopy = C.id
											 	AND (Global.extendedFlags & @encryptOnPrimaryExBit) > 0
											)
											OR
											(
												AG.defaultCopy <> C.id
												AND (Global.flags &  (@reencBit | @netOnlyEncBit)) > 0
											)
										then Global.encType
										else 0 end),
				encKeyLen		= (case when
											(
												AG.defaultCopy = C.id
											 	AND (Global.extendedFlags & @encryptOnPrimaryExBit) > 0
											)
											OR
											(
												AG.defaultCopy <> C.id
												AND (Global.flags &  (@reencBit | @netOnlyEncBit)) > 0
											)
										then Global.encKeyLen
										else 0 end),
				flags			= (
									--Unset dependent copy enc flags
									C.flags & ~(@encMask | @storeOnMediaBit) |
									--Set DirectMediaAccess flag from global policy
									(Global.flags & @storeOnMediaBit) |
									--Set enc flags from global policy
									-- Primary copy - if don't encrypt is selected then set passthrough else re-encrypt
									-- Secondary copy - enc flags on global policy are for secondary only
									(
										case when AG.defaultCopy = C.id AND (Global.extendedFlags & @encryptOnPrimaryExBit) > 0
											then @reencBit
											when AG.defaultCopy <> C.id
											then (Global.flags & @encMask)
											else @passThruBit
										end
									)
								)
				FROM archGroupCopy C
				INNER JOIN archGroup AG WITH(READUNCOMMITTED) ON C.archGroupId = AG.id
				INNER JOIN Inserted I ON C.id = I.id
				INNER JOIN archCopyToGlobalPolicy G WITH (READUNCOMMITTED) ON G.copyId = I.Id
				INNER JOIN archGroup GAG WITH (READUNCOMMITTED) ON G.globalPolicyId = GAG.id
				INNER JOIN archGroupCopy Global ON GAG.defaultCopy = Global.id
				WHERE C.isSnapCopy = 0
				AND (C.extendedFlags & 65536 /*CVA_OVERRIDE_ENCRYPTION_OF_GLOBAL_POLICY*/) = 0
		END
		-- Update the transitive copy properties.
		IF (UPDATE(flags) OR UPDATE(waitForIfOffline) OR UPDATE(waitForIfBusy) OR UPDATE(maxStreamNum))
		AND EXISTS (SELECT 1 FROM INSERTED WHERE flags & 33554432/*CVA_ENABLE_MEDIA_REFRESHING_FLAG*/ <> 0)
		BEGIN
			UPDATE	AGC
			SET		flags = (AGC.flags & ~(512 + 16 + 8)) | (I.flags & (512 + 16 + 8)), waitForIfOffline = I.waitForIfOffline, waitForIfBusy = I.waitForIfBusy, maxStreamNum = I.maxStreamNum
			FROM	Inserted I
					INNER JOIN archCopyMediaRefreshProp P ON P.CopyId = I.id
					INNER JOIN archGroupCopy AGC ON AGC.id = P.targetCopyId
		END
		--If GDSP settings are modified replicate it to dependent copies
		IF  (UPDATE(dedupeFlags) OR UPDATE(sealStoreTaskId) OR UPDATE(siloAppId) OR UPDATE(nDataInstance) OR
			UPDATE(silosInCache) OR UPDATE(siloRestoreMAClientId) OR UPDATE(siloRestoreClientId) OR UPDATE(SIDBSnapIntervalHours))
		AND EXISTS (SELECT * FROM INSERTED WHERE (dedupeFlags & 268435456) <> 0 ) --CVA_HOST_GLOBAL_DEDUP_STORE_FLAG
		BEGIN
			DECLARE	@COPY_DEDUP_FLAGS	INT
			SET	@COPY_DEDUP_FLAGS = (2 | 4 | 8 | 2097152 | 4194304 | 16777216 | 33554432 | 67108864)
			-- 2=CVA_ENABLE_SIGNATURE_BACKWARD_REF_FLAG,4=CVA_OPTIMIZE_HIGH_LATENCY_NETWORK_FLAG, 8=CVA_SIDB_RESILIENCY_ENABLED_FLAG, 2097152=CVA_BACKUP_SILO_ENABLED_FLAG, 4194304=CVA_KEEP_ACTIVE_SILO_IN_CACHE_FLAG, 16777216=CVA_ENABLE_SILO_DISK_SPACE_MANAGEMENT_FLAG,
			-- 33554432=CVA_RECONSTRUCT_SIDB_FROM_SNAPSHOT_FLAG, 67108864=CVA_AUTO_RECONSTRUCT_DEDUP_STORE_FLAG
			UPDATE	DepCopy
			SET		dedupeFlags			= (DepCopy.dedupeFlags & ~@COPY_DEDUP_FLAGS) | (GCI.dedupeFlags & @COPY_DEDUP_FLAGS),
					sealStoreTaskId		= GCI.sealStoreTaskId,
					siloAppId			= GCI.siloAppId,
					nDataInstance		= GCI.nDataInstance,
					silosInCache		= GCI.silosInCache,
					siloRestoreMAClientId	= GCI.siloRestoreMAClientId,
					siloRestoreClientId		= GCI.siloRestoreClientId,
					SIDBSnapIntervalHours	= GCI.SIDBSnapIntervalHours
			FROM	archGroupCopy DepCopy
					INNER JOIN archCopyToGlobalPolicy ACTG WITH (READUNCOMMITTED) ON DepCopy.id = ACTG.copyId
					INNER JOIN Inserted GCI ON ACTG.globalPolicyId = GCI.archGroupId
			WHERE	 (DepCopy.dedupeFlags & 134217728 > 0) --CVA_USE_GLOBAL_DEDUP_STORE_FLAG
                     AND    ((DepCopy.dedupeFlags & @COPY_DEDUP_FLAGS) <> (GCI.dedupeFlags & @COPY_DEDUP_FLAGS)				      							OR	DepCopy.sealStoreTaskId		<> GCI.sealStoreTaskId
							OR	DepCopy.siloAppId			<> GCI.siloAppId
							OR	DepCopy.nDataInstance		<> GCI.nDataInstance
							OR	DepCopy.silosInCache		<> GCI.silosInCache
							OR	DepCopy.siloRestoreMAClientId	<> GCI.siloRestoreMAClientId
							OR	DepCopy.siloRestoreClientId		<> GCI.siloRestoreClientId
							OR	DepCopy.SIDBSnapIntervalHours	<> GCI.SIDBSnapIntervalHours)
			--if dedupe inactive flag was modified for GDSP, copy it to all dependent copies which are not overriding GDSP setting. This can be done in above query itself, but it will make that query hard to read
			UPDATE	DepCopy
			SET		dedupeFlags	= (DepCopy.dedupeFlags & ~1048576) | (GCI.dedupeFlags & 1048576)--CVA_DEDUP_INACTIVE_FLAG
			FROM	archGroupCopy DepCopy
					INNER JOIN archCopyToGlobalPolicy ACTG WITH (READUNCOMMITTED) ON DepCopy.id = ACTG.copyId
					INNER JOIN Inserted GCI ON ACTG.globalPolicyId = GCI.archGroupId
			WHERE	(DepCopy.dedupeFlags & 1048576) <> (GCI.dedupeFlags & 1048576) --CVA_DEDUP_INACTIVE_FLAG
					AND (GCI.dedupeFlags & 134217728) <> 0--CVA_USE_GLOBAL_DEDUP_STORE_FLAG
					AND	(DepCopy.dedupeFlags & 32) = 0 --CVA_DEDUP_INACTIVE_FLAG_SET_ON_DEPENDENT
		END
		--if CVA_DEDUP_INACTIVE_FLAG is getting modified for a dependent copy
		IF (UPDATE(dedupeFlags)
			AND EXISTS (SELECT 1 FROM Inserted I INNER JOIN Deleted D ON I.id = D.id
						WHERE (I.dedupeFlags & 1048576/*CVA_DEDUP_INACTIVE_FLAG*/) <> (D.dedupeFlags & 1048576/*CVA_DEDUP_INACTIVE_FLAG*/) AND (I.dedupeFlags&134217728/*CVA_USE_GLOBAL_DEDUP_STORE_FLAG*/) <>0))
		BEGIN
			UPDATE	DepCopy
					-- set or clear CVA_DEDUP_INACTIVE_FLAG_SET_ON_DEPENDENT when CVA_DEDUP_INACTIVE_FLAG is getting set or cleared on dependent. Also keep CVA_DEDUP_INACTIVE_FLAG set if its set on GDSP
			SET		dedupeFlags	= (DepCopy.dedupeFlags & ~32/*CVA_DEDUP_INACTIVE_FLAG_SET_ON_DEPENDENT*/) | IIF(DepI.dedupeFlags&1048576/*CVA_DEDUP_INACTIVE_FLAG*/<>0, 32/*CVA_DEDUP_INACTIVE_FLAG_SET_ON_DEPENDENT*/, 0) | (GlobalCopy.dedupeFlags&1048576/*CVA_DEDUP_INACTIVE_FLAG*/)
			FROM	archGroupCopy DepCopy
					INNER JOIN Inserted DepI ON DepCopy.id = DepI.id
					INNER JOIN archCopyToGlobalPolicy ACGP WITH (READUNCOMMITTED) ON DepCopy.id = ACGP.copyId
					INNER JOIN archGroup GlobalSP WITH (READUNCOMMITTED) ON ACGP.globalPolicyId = GlobalSP.id
					INNER JOIN archGroupCopy GlobalCopy WITH (READUNCOMMITTED) ON GlobalSP.defaultCopy = GlobalCopy.id
			WHERE	(DepCopy.dedupeFlags & 134217728) <> 0--CVA_USE_GLOBAL_DEDUP_STORE_FLAG
		END
		IF UPDATE(dedupeFlags)
		BEGIN
			IF EXISTS (SELECT 1 FROM INSERTED I WHERE (I.dedupeFlags & 16) > 0)
			BEGIN
				UPDATE 	AGCSecondary
				SET 	AGCSecondary.dedupeFlags = (AGCSecondary.dedupeFlags & ~(8388608)) | 524288
				FROM 	INSERTED I, archGroupCopy AGCSecondary, archGroup AG, archGroupCopy AGC, ArchCopySIDBStore ACSI, ArchCopySIDBStore ACSP
				WHERE 	ACSI.copyId = I.Id
						AND ACSP.copyId = AGC.id
						AND	ACSI.SIDBStoreId = ACSP.SIDBStoreId
						AND ACSI.flags & ACSP.flags & 4 > 0
						AND AGC.id = AG.defaultCopy
						AND AGCSecondary.archGroupId = AGC.archGroupId
						AND AGCSecondary.sourceCopyId = 0
						AND (AGCSecondary.dedupeFlags & 262144) > 0
						AND (AGCSecondary.dedupeFlags & 8388608) > 0
			END
		END
		-- Update the associated dependent copies of Global Copy. Update only those that do not override the Global encryption. CVA_OVERRIDE_ENCRYPTION_OF_GLOBAL_POLICY
		IF ((UPDATE(encType) OR UPDATE(encKeyLen) OR UPDATE(flags)) AND EXISTS
	 		(SELECT 1 FROM Inserted I INNER JOIN archGroupCopy C ON I.Id = C.id
				WHERE (((C.extendedFlags & (1|4096)) <> 0) /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG OR CVA_GLOBAL_STORAGE_POLICY_FLAG*/
				OR ((C.dedupeFlags & 268435456) <> 0) /*CVA_HOST_GLOBAL_DEDUP_STORE_FLAG*/)))
	 	BEGIN
				UPDATE Dep
				SET	encType 	= (case when
											(
												AG.defaultCopy = Dep.id
											 	AND (Global.extendedFlags & @encryptOnPrimaryExBit) > 0
											)
											OR
											(
												AG.defaultCopy <> Dep.id
												AND (Global.flags &  (@reencBit | @netOnlyEncBit)) > 0
											)
										then Global.encType
										else 0 end),
				encKeyLen		= (case when
											(
												AG.defaultCopy = Dep.id
											 	AND (Global.extendedFlags & @encryptOnPrimaryExBit) > 0
											)
											OR
											(
												AG.defaultCopy <> Dep.id
												AND (Global.flags &  (@reencBit | @netOnlyEncBit)) > 0
											)
										then Global.encKeyLen
										else 0 end),
				flags			= (
									--Unset dependent copy enc flags
									Dep.flags & ~(@encMask | @storeOnMediaBit) |
									--Set DirectMediaAccess flag from global policy
									(Global.flags & @storeOnMediaBit) |
									--Set enc flags from global policy
									-- Primary copy - if don't encrypt is selected then set passthrough else re-encrypt
									-- Secondary copy - enc flags on global policy are for secondary only
									(
										case when AG.defaultCopy = Dep.id AND (Global.extendedFlags & @encryptOnPrimaryExBit) > 0
											then @reencBit
											when AG.defaultCopy <> Dep.id
											then (Global.flags & @encMask)
											else @passThruBit
										end
									)
								)
				FROM archGroup AG WITH(READUNCOMMITTED), archGroupCopy Global, INSERTED AS I, archGroupCopy Dep
					INNER JOIN archCopyToGlobalPolicy G WITH (READUNCOMMITTED) ON G.copyId = Dep.Id
				WHERE Global.Id = I.Id AND Dep.archGroupId = AG.id
				AND  (Global.archGroupId = G.globalPolicyId)
				AND Dep.extendedFlags & 65536 /*CVA_OVERRIDE_ENCRYPTION_OF_GLOBAL_POLICY*/ = 0
				AND Dep.isSnapCopy = 0
                AND ((Global.extendedFlags & 1 /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG*/) <> 0
					OR
                     (Global.dedupeFlags & 268435456 /*CVA_HOST_GLOBAL_DEDUP_STORE_FLAG*/) <> 0
                    OR
					 (Global.extendedFlags & 4096 /*CVA_GLOBAL_STORAGE_POLICY_FLAG*/) <> 0 )
		END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchGroupCopyUpgTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchGroupCopyUpgTrigger' AND revision = '1.18.42.13')

  insert into GXDBVersions values(6, 'ArchGroupCopyUpgTrigger',  '1.18.42.13', 'ArchGroupCopyUpgTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

