

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchAgingRuleUpdTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchAgingRuleUpdTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchAgingRuleUpdTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchAgingRuleUpdTrigger]
  delete from GXDBVersions where name = 'ArchAgingRuleUpdTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchAgingRuleUpdTrigger
	ON ArchAgingRule
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
	DECLARE @l_allowRetentionReduceOfWormCopy INT
	SET @l_allowRetentionReduceOfWormCopy = 0
	SELECT @l_allowRetentionReduceOfWormCopy = value
	FROM MMConfigs WHERE name ='DA_CONFIG_ALLOW_JOB_RETENTION_CHANGE_ON_WORM_COPY'
	IF @l_allowRetentionReduceOfWormCopy <> 1
	BEGIN
		UPDATE	archAgingRule
		SET		retentionDays = D.retentionDays, fullCycles = D.fullCycles, archiverRetDays = D.archiverRetDays, retentionJobs = D.retentionJobs
		FROM	archGroupCopy AS AGC WITH(NOLOCK), Deleted AS D
		WHERE	archAgingRule.copyId = D.copyId AND AGC.id = D.copyId AND (AGC.flags & 16777216) <> 0
			AND (archAgingRule.retentionDays <> -1 AND (archAgingRule.retentionDays < D.retentionDays OR D.retentionDays = -1)
			  OR archAgingRule.fullCycles <> -1 AND (archAgingRule.fullCycles < D.fullCycles OR D.fullCycles = -1)
			  OR archAgingRule.retentionJobs <> -1 AND (archAgingRule.retentionJobs < D.retentionJobs OR D.retentionJobs = -1)
			  OR archAgingRule.archiverRetDays <> -1 AND (archAgingRule.archiverRetDays < D.archiverRetDays OR D.archiverRetDays = -1))
	END
	DECLARE @copyIdList table(copyId int)
	INSERT INTO @copyIdList
	SELECT copyId FROM INSERTED
		UPDATE	archAgingRule
		SET		retentionDays = I.retentionDays, fullCycles = I.fullCycles, flags = I.flags,
				weekStart = I.weekStart, monthStart = I.monthStart, yearStart = I.yearStart, archiverRetDays = I.archiverRetDays , minutesSinceDayStarts = I.minutesSinceDayStarts ,
				retentionJobs = I.retentionJobs
		OUTPUT INSERTED.copyId INTO @copyIdList
		FROM	archGroupCopy AS AGC WITH(NOLOCK), INSERTED AS I
		WHERE	archAgingRule.copyId = AGC.id
			AND (AGC.sourceCopyId = I.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WITH(NOLOCK) WHERE sourceCopyId = I.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
     DECLARE @l_extendedFlags BIGINT
     SELECT @l_extendedFlags = C.extendedFlags
     FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
     IF @l_extendedFlags IS NOT NULL AND ((@l_extendedFlags & 1) <> 0) /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG*/
     BEGIN
			UPDATE	archAgingRule
			SET		retentionDays = I.retentionDays, fullCycles = I.fullCycles, flags = I.flags,
				weekStart = I.weekStart, monthStart = I.monthStart, yearStart = I.yearStart, archiverRetDays = I.archiverRetDays , minutesSinceDayStarts = I.minutesSinceDayStarts ,
				retentionJobs = I.retentionJobs
			OUTPUT INSERTED.copyId INTO @copyIdList
			FROM	archGroupCopy AS AGC WITH(NOLOCK), INSERTED AS I
			WHERE	archAgingRule.copyId = AGC.id
			AND AGC.destMediaCopyId = I.copyId
			AND ((AGC.extendedFlags & 2048) = 0) /*CVA_OVERRIDE_RETENTION_OF_GLOBAL_POLICY*/
	END
		INSERT INTO JMJobDataStatsTracking (commCellId, jobId, archGrpCopyId, dataType)
		SELECT distinct 0, 0, copyId, 0
		FROM @copyIdList
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchAgingRuleUpdTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchAgingRuleUpdTrigger' AND revision = '1.15.190.5')

  insert into GXDBVersions values(6, 'ArchAgingRuleUpdTrigger',  '1.15.190.5', 'ArchAgingRuleUpdTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

