

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchAgingRuleExtendedUpdTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchAgingRuleExtendedUpdTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchAgingRuleExtendedUpdTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchAgingRuleExtendedUpdTrigger]
  delete from GXDBVersions where name = 'ArchAgingRuleExtendedUpdTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchAgingRuleExtendedUpdTrigger
	ON ArchAgingRuleExtended
	AFTER UPDATE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
	DECLARE @l_allowRetentionReduceOfWormCopy INT
	SET @l_allowRetentionReduceOfWormCopy = 0
	SELECT @l_allowRetentionReduceOfWormCopy = value
	FROM MMConfigs WHERE name ='DA_CONFIG_ALLOW_JOB_RETENTION_CHANGE_ON_WORM_COPY'
	IF @l_allowRetentionReduceOfWormCopy <> 1
	BEGIN
		UPDATE	ArchAgingRuleExtended
		SET		retentionDays = D.retentionDays
		FROM	archGroupCopy AS AGC, Deleted AS D
		WHERE	ArchAgingRuleExtended.copyId = D.copyId AND ArchAgingRuleExtended.retentionRule = D.retentionRule
			AND AGC.id = D.copyId AND (AGC.flags & 16777216) <> 0
			AND ArchAgingRuleExtended.retentionDays <> -1 AND (ArchAgingRuleExtended.retentionDays < D.retentionDays OR D.retentionDays = -1)
	END
		UPDATE	ArchAgingRuleExtended
		SET		retentionDays = I.retentionDays, currPeriodBegin = I.currPeriodBegin,
					currPeriodEnd = I.currPeriodEnd, prevPeriodBegin = I.prevPeriodBegin,
					nextPeriodEnd = I.nextPeriodEnd, GraceDays = I.GraceDays , EveryXHours = I.EveryXHours
		FROM	archGroupCopy AS AGC, INSERTED AS I
		WHERE	ArchAgingRuleExtended.copyId = AGC.id AND ArchAgingRuleExtended.retentionRule = I.retentionRule
			AND (AGC.sourceCopyId = I.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = I.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
     DECLARE @l_extendedFlags BIGINT
     SELECT @l_extendedFlags = C.extendedFlags
     FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
     IF @l_extendedFlags IS NOT NULL AND (@l_extendedFlags & 1) <> 0 /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG*/
     BEGIN
			UPDATE	ArchAgingRuleExtended
			SET		retentionDays = I.retentionDays, currPeriodBegin = I.currPeriodBegin,
					currPeriodEnd = I.currPeriodEnd, prevPeriodBegin = I.prevPeriodBegin,
					nextPeriodEnd = I.nextPeriodEnd, GraceDays = I.GraceDays , EveryXHours = I.EveryXHours
			FROM	archGroupCopy AS AGC WITH(NOLOCK), INSERTED AS I
			WHERE	ArchAgingRuleExtended.copyId = AGC.id
			AND AGC.destMediaCopyId = I.copyId
			AND ArchAgingRuleExtended.retentionRule = I.retentionRule
			AND ((AGC.extendedFlags & 2048) = 0) /*CVA_OVERRIDE_RETENTION_OF_GLOBAL_POLICY*/
		END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchAgingRuleExtendedUpdTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchAgingRuleExtendedUpdTrigger' AND revision = '1.9.200.4')

  insert into GXDBVersions values(6, 'ArchAgingRuleExtendedUpdTrigger',  '1.9.200.4', 'ArchAgingRuleExtendedUpdTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

