

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchAgingRuleExtendedInsTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchAgingRuleExtendedInsTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchAgingRuleExtendedInsTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchAgingRuleExtendedInsTrigger]
  delete from GXDBVersions where name = 'ArchAgingRuleExtendedInsTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchAgingRuleExtendedInsTrigger
	ON ArchAgingRuleExtended
	AFTER INSERT
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
		DELETE	ArchAgingRuleExtended
		FROM	INSERTED AS I,
				(SELECT	copyId, COUNT(DISTINCT retentionRule) AS nRules
				FROM	ArchAgingRuleExtended
				WHERE	copyId IN (SELECT DISTINCT copyId FROM INSERTED)
				GROUP BY copyId) AS T
		WHERE	I.copyId = T.copyId AND T.nRules > 3
			AND ArchAgingRuleExtended.copyId = I.copyId AND ArchAgingRuleExtended.retentionRule = I.retentionRule
		DELETE	ArchAgingRuleExtended
		FROM	archGroupCopy AS AGC, INSERTED AS I
		WHERE	ArchAgingRuleExtended.copyId = AGC.id AND ArchAgingRuleExtended.retentionRule = I.retentionRule
			AND (AGC.sourceCopyId = I.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = I.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
		INSERT	INTO ArchAgingRuleExtended
		SELECT	AGC.id,	I.retentionDays, I.retentionRule, I.currPeriodBegin,
						I.currPeriodEnd, I.prevPeriodBegin, I.nextPeriodEnd, I.GraceDays , I.EveryXHours
		FROM	archGroupCopy AS AGC, INSERTED AS I
		WHERE	(AGC.sourceCopyId = I.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = I.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
    	DECLARE @l_extendedFlags BIGINT
    	SELECT @l_extendedFlags = C.extendedFlags
    	FROM Inserted I INNER JOIN archGroupCopy C ON I.CopyId = C.id
    	IF @l_extendedFlags IS NOT NULL AND (@l_extendedFlags & 1) <> 0 /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG*/
    	BEGIN
			INSERT INTO ArchAgingRuleExtended
			SELECT	AGC.id,	I.retentionDays, I.retentionRule, I.currPeriodBegin,
					I.currPeriodEnd, I.prevPeriodBegin,
					I.nextPeriodEnd, I.GraceDays, I.EveryXHours
			FROM	archGroupCopy AS AGC WITH(NOLOCK), INSERTED AS I
			WHERE	AGC.destMediaCopyId = I.copyId
			AND ((AGC.extendedFlags & 2048) = 0) /*CVA_OVERRIDE_RETENTION_OF_GLOBAL_POLICY*/
		END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchAgingRuleExtendedInsTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchAgingRuleExtendedInsTrigger' AND revision = '1.8.72.3')

  insert into GXDBVersions values(6, 'ArchAgingRuleExtendedInsTrigger',  '1.8.72.3', 'ArchAgingRuleExtendedInsTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

