

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/ArchAgingRuleExtendedDelTrigger.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: ArchAgingRuleExtendedDelTrigger'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchAgingRuleExtendedDelTrigger]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[ArchAgingRuleExtendedDelTrigger]
  delete from GXDBVersions where name = 'ArchAgingRuleExtendedDelTrigger' and type = 6
END
GO

	CREATE TRIGGER ArchAgingRuleExtendedDelTrigger
	ON ArchAgingRuleExtended
	AFTER DELETE
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows deleted
		SET NOCOUNT ON
		IF EXISTS(SELECT TOP 1 AFC.* FROM archGroupCopy AGC
		INNER JOIN Deleted D ON D.copyId = AGC.id AND (AGC.flags & 16777216) <> 0
		INNER JOIN archFileCopy AFC ON AFC.archCopyId = AGC.id AND (AFC.flags & 256) = 0)
		BEGIN
			INSERT	INTO ArchAgingRuleExtended
			SELECT	D.*
			FROM	archGroupCopy AS AGC, Deleted AS D
			WHERE	AGC.id = D.copyId AND (AGC.flags & 16777216) <> 0
		END
		DELETE	ArchAgingRuleExtended
		FROM	archGroupCopy AS AGC, DELETED AS D
		WHERE	ArchAgingRuleExtended.copyId = AGC.id AND ArchAgingRuleExtended.retentionRule = D.retentionRule
			AND (AGC.sourceCopyId = D.copyId OR
				AGC.sourceCopyId IN (SELECT id FROM archGroupCopy WHERE sourceCopyId = D.copyId AND isSnapCopy = 1 AND isMirrorCopy = 1))
			AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 1
     DECLARE @l_extendedFlags BIGINT
     SELECT @l_extendedFlags = C.extendedFlags
     FROM DELETED D INNER JOIN archGroupCopy C ON D.CopyId = C.id
     IF @l_extendedFlags IS NOT NULL AND (@l_extendedFlags & 1) <> 0 /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG*/
     BEGIN
			DELETE	A
			FROM	ArchAgingRuleExtended A, archGroupCopy AS AGC WITH(NOLOCK), DELETED AS D
			WHERE	A.copyId = AGC.id
			AND AGC.destMediaCopyId = D.copyId
			AND A.retentionRule = D.retentionRule
			AND ((AGC.extendedFlags & 2048) = 0) /*CVA_OVERRIDE_RETENTION_OF_GLOBAL_POLICY*/
		END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [ArchAgingRuleExtendedDelTrigger]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'ArchAgingRuleExtendedDelTrigger' AND revision = '1.5.210.4')

  insert into GXDBVersions values(6, 'ArchAgingRuleExtendedDelTrigger',  '1.5.210.4', 'ArchAgingRuleExtendedDelTrigger', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

