

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/App_Application_SmartTopologyUpdate.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: App_Application_SmartTopologyUpdate'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[App_Application_SmartTopologyUpdate]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[App_Application_SmartTopologyUpdate]
  delete from GXDBVersions where name = 'App_Application_SmartTopologyUpdate' and type = 6
END
GO

	CREATE TRIGGER [dbo].[App_Application_SmartTopologyUpdate]
	   ON  [dbo].[APP_Application]
	   AFTER UPDATE
	AS
	DECLARE @currentTime INT
	BEGIN
		IF @@ROWCOUNT = 0
			RETURN
		IF NOT UPDATE(dataArchGrpID) AND NOT UPDATE(logArchGrpID)
			RETURN
		SET NOCOUNT ON
		IF OBJECT_ID('tempdb..#clients') IS NOT NULL
			DROP TABLE #clients

		-- Temp Table to hold clients and their old and new SPs.
		CREATE TABLE #clients
		(
			clientId INT,
			oldArchGroupId INT,
			newArchGroupId INT
		)

		IF OBJECT_ID('tempdb..#sps') IS NOT NULL
			DROP TABLE #sps

		-- Temp Table to hold relevant SPs
		CREATE TABLE #sps
		(
			archGroupId INT PRIMARY KEY
		)

		-- Get the affected SPs
		-- Don't push to clients that are not part of atleast one smart topology with 'My Media Agents' or 'My Commserve & Media Agents'
		INSERT INTO #clients
		SELECT Clients.ClientId, Clients.oldArchGrpId, Clients.newArchGrpId
		FROM
		(
			SELECT I.ClientId, D.dataArchGrpId oldArchGrpId, I.dataArchGrpId newArchGrpId
			FROM INSERTED I INNER JOIN DELETED D ON I.id = D.id WHERE I.dataArchGrpId <> D.dataArchGrpId
			UNION
			SELECT I.ClientId, D.logArchGrpId oldArchGrpId, I.logArchGrpId newArchGrpId
			FROM INSERTED I INNER JOIN DELETED D ON I.id = D.id WHERE I.logArchGrpId <> D.logArchGrpId
		) Clients
		INNER JOIN APP_ClientGroupAssoc ACGA WITH(READUNCOMMITTED) ON Clients.clientId = ACGA.clientId
		INNER JOIN
		(SELECT AFTA.topologyId, AFTA.fwGroupType, AFTA.groupId FROM APP_FirewallTopologyAssoc AFTA WITH(READUNCOMMITTED)
		INNER JOIN APP_FirewallTopology AFT WITH(READUNCOMMITTED) ON AFTA.topologyId = AFT.topologyId AND AFT.flag & 1 = 1 AND AFTA.fwGroupType IN (1,2) AND AFTA.groupId > 0
		INNER JOIN APP_FirewallTopologyAssoc AFTA1 WITH(READUNCOMMITTED) ON AFTA1.topologyId = AFT.topologyId AND AFTA1.fwGroupType IN (1,2) AND AFTA1.groupId IN (-2,-3)
		) TopoAssoc
		ON ACGA.clientGroupId = TopoAssoc.groupId

		INSERT INTO #sps
		SELECT oldArchGroupId FROM #clients
		UNION
		SELECT newArchGroupId FROM #clients

		-- Also get the incrSPs for the storage policies.
		INSERT INTO #sps
		SELECT DISTINCT AG.incrSP FROM archGroup AG WITH(READUNCOMMITTED) INNER JOIN #sps SP ON AG.id = SP.archGroupId
		WHERE 	AG.incrSP > 1
				AND NOT EXISTS (SELECT 1 FROM #sps WHERE archGroupId = AG.incrSP)

		SET @currentTime = dbo.GetUnixTime(GetUTCDate())
		INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
		SELECT clientId, -1, 5, '', @currentTime, 0, 0, 0 FROM
		(
			-- Clients
			SELECT clientId FROM #clients
			UNION
			-- Datapath MAs
			SELECT DrivePool.ClientId FROM #sps SP
			INNER JOIN archGroup AG WITH(READUNCOMMITTED) ON AG.id = SP.archGroupId
			INNER JOIN MMDataPath DataPath WITH(READUNCOMMITTED) ON DataPath.CopyId = AG.defaultCopy OR (AG.defaultSnapCopy > 0 AND DataPath.CopyId = AG.defaultSnapCopy)
			INNER JOIN MMDrivePool DrivePool WITH(READUNCOMMITTED) ON DataPath.DrivePoolId = DrivePool.DrivePoolId
			UNION
			-- DDB MAs
			SELECT SubStore.clientId FROM #sps SP
			INNER JOIN archGroup AG WITH(READUNCOMMITTED) ON AG.id = SP.archGroupId
			INNER JOIN archCopySIDBStore ACSStore WITH(READUNCOMMITTED) ON ACSStore.CopyId = AG.defaultCopy
			INNER JOIN IdxSIDBSubStore SubStore WITH(READUNCOMMITTED) ON SubStore.SIDBStoreId = ACSStore.SIDBStoreId
		) PushClientList(clientId)

		IF OBJECT_ID('tempdb..#clients') IS NOT NULL
			DROP TABLE #clients

		IF OBJECT_ID('tempdb..#sps') IS NOT NULL
			DROP TABLE #sps

		SET NOCOUNT OFF
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [App_Application_SmartTopologyUpdate]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'App_Application_SmartTopologyUpdate' AND revision = '')

  insert into GXDBVersions values(6, 'App_Application_SmartTopologyUpdate',  '', 'App_Application_SmartTopologyUpdate', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

