

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/App_Application_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: App_Application_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[App_Application_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[App_Application_AfterUpd]
  delete from GXDBVersions where name = 'App_Application_AfterUpd' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER App_Application_AfterUpd
ON App_Application
AFTER UPDATE
AS
BEGIN
	IF @@ROWCOUNT = 0
		RETURN			--If no rows updated
	SET NOCOUNT ON
	DECLARE @currentTime INTEGER
	SET 		@currentTime = dbo.GetUnixTime(GETUTCDATE())
	IF (UPDATE(dataArchGrpID))
 	BEGIN
		-- This IF block reworked due to deadlock (within the trigger itself) found in SP15 being incurred during VSA Operations when APP_Application
		-- table updated due to 5 separate UPDATE / INSERT Ops against the APP_SubClientProp table.
		-- A number of other triggers (CCS, Firewall) are being repeatedly fired due to the 5 separate UPDATE / INSERT Ops
		-- being executed so optimization done to compute all the needed data into temp tables then perform 1 UPDATE and 1 INSERT Ops only.
		DECLARE @workRows TABLE (
			scId			INT,
			appTypeId		INT,
			isCWEjobValid	INT,
			del_dataArchGrpId INT,
			PRIMARY KEY (appTypeId, scId)
		)
		-- Now get all updated rows where dataArchGrpId has changed
		DECLARE @rcnt INT = 0
		INSERT INTO @workRows (scId, appTypeId, isCWEjobValid, del_dataArchGrpId)
			SELECT
				i.id,
				i.appTypeId,
				it.isCWEjobValid,
				d.dataArchGrpID
			FROM
				INSERTED i
				INNER JOIN DELETED d ON
					i.Id = d.Id
					AND i.dataArchGrpID != d.dataArchGrpID
				INNER JOIN APP_iDAType it WITH(NOLOCK) ON
					it.type = i.appTypeId
		SET @rcnt = @@ROWCOUNT
		IF (@rcnt > 0)
		BEGIN
			IF OBJECT_ID('TempDb..#SCDelProps') IS NOT NULL
				DROP TABLE #SCProps
			CREATE TABLE #SCDelProps (
				scpId			INT PRIMARY KEY
			)
			INSERT INTO #SCDelProps (scpId)
				SELECT
					scp.id
				FROM
					@workRows wr
					INNER JOIN App_SubclientProp scp WITH(NOLOCK) ON
						wr.appTypeId != 1030
						AND wr.scId = scp.componentNameId
						AND scp.attrName = N'sys:last full start with SP Change'
						AND scp.modified = 0
						AND scp.cs_attrName = CHECKSUM(N'sys:last full start with SP Change')
				UNION ALL
				SELECT
					scp.id
				FROM
					@workRows wr
					INNER JOIN App_SubclientProp scp WITH(NOLOCK) ON
						wr.scId = scp.componentNameId
						AND scp.attrName = N'DDB Backup CopyId'
						AND scp.modified = 0
						AND scp.cs_attrName = CHECKSUM(N'DDB Backup CopyId')
				WHERE wr.del_dataArchGrpId > 1
			IF OBJECT_ID('TempDb..#SCNewProps') IS NOT NULL
				DROP TABLE #SCNewProps
			CREATE TABLE #SCNewProps (
				scId			INT PRIMARY KEY,
				servStartDate	INT
			)
			-- The following 3 INSERT Ops are similar and possibly merge but we want the MAX servStartDate in this order based on conditionals meet
			INSERT INTO #SCNewProps (scId, servStartDate)
				SELECT
					jbs.appId,
					MAX(jbs.servStartDate)
				FROM
					@workRows wr
					INNER JOIN JMBkpStats jbs WITH(NOLOCK) ON
						wr.appTypeId != 1030
						AND wr.scId = jbs.appId
						AND (
							jbs.status IN (1, 14)
							OR (
								wr.isCWEjobValid = 1
								AND jbs.status = 3
							)
						)
						AND jbs.bkpLevel in (1, 64, 128, 1024, 32768, 131072, 262144)
						AND jbs.datastatus = 0
						AND jbs.optype != 60 -- SNAPTOTAPE
				GROUP BY
					jbs.appId
			INSERT INTO #SCNewProps (scId, servStartDate)
				SELECT
					jbs.appId,
					MAX(jbs.servStartDate)
				FROM
					@workRows wr
					INNER JOIN JMBkpStats jbs WITH(NOLOCK) ON
						wr.appTypeId != 1030
						AND wr.scId = jbs.appId
						AND jbs.status IN (1, 3, 14)
						AND jbs.bkpLevel in (1, 64, 128, 1024, 32768, 131072, 262144)
						AND jbs.datastatus = 0
						AND jbs.optype != 60 -- SNAPTOTAPE
					LEFT OUTER JOIN #SCNewProps p ON
						p.scId = jbs.appId
				WHERE
					p.scId IS NULL
				GROUP BY
					jbs.appId
			INSERT INTO #SCNewProps (scId, servStartDate)
				SELECT
					jbs.appId,
					MAX(jbs.servStartDate)
				FROM
					@workRows wr
					INNER JOIN JMBkpStats jbs WITH(NOLOCK) ON
						wr.appTypeId != 1030
						AND wr.scId = jbs.appId
						AND jbs.status IN (1, 3, 14)
						AND jbs.datastatus = 0
						AND jbs.optype != 60 -- SNAPTOTAPE
					LEFT OUTER JOIN #SCNewProps p ON
						p.scId = jbs.appId
				WHERE
					p.scId IS NULL
				GROUP BY
					jbs.appId
			-- Now apply updates to the APP_SubClientProp table
			UPDATE scp
				SET modified = @currentTime
			FROM APP_SubClientProp scp
				INNER JOIN #SCDelProps p ON
					p.scpId = scp.id
			INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				SELECT
					p.scId,
					N'sys:last full start with SP Change',
					10,
					p.servStartDate,
					@currentTime,
					0,
					0
				FROM #SCNewProps p
		END
	END
	IF (UPDATE(logArchGrpID))
	BEGIN
		DECLARE @checkSumLastLogSP int
		SET @checkSumLastLogSP = CHECKSUM(N'last log SP')
		-- A future performance change would be to merge the above IF block and this IF block to write the
		-- computed data needed to temp tables so that only 1 UPDATE and 1 INSERT Op are performed for the entire trigger.
		-- Added in SP16 so could possible be another deadlock with simultaneous trigger firings.
		UPDATE PROP
			SET modified = @currentTime
		FROM App_SubclientProp PROP,
			Inserted I,
			Deleted D
		WHERE
			I.Id = D.Id
			AND I.logArchGrpID <> D.logArchGrpID
			AND PROP.attrVal <> CAST(D.logArchGrpID AS NVARCHAR(12))	-- safer to cast the integer to nvarchar
			AND I.Id = PROP.componentNameId
			AND PROP.attrName = N'last log SP'
			AND PROP.cs_attrName = @checkSumLastLogSP
			AND PROP.modified = 0
		INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
			SELECT
				I.Id,
				N'last log SP',
				10,
				D.logArchGrpID,
				@currentTime,
				0,
				0
			FROM Inserted I
				INNER JOIN Deleted D ON
					I.Id = D.Id
					AND	I.logArchGrpID <> D.logArchGrpID
				LEFT OUTER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
					scp.attrName = N'last log SP'
					AND scp.modified = 0
					AND scp.componentNameId = I.id
					AND scp.cs_attrName =  @checkSumLastLogSP
				WHERE
					scp.id IS NULL
	END
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [App_Application_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'App_Application_AfterUpd' AND revision = '1.1.4.15')

  insert into GXDBVersions values(6, 'App_Application_AfterUpd',  '1.1.4.15', 'App_Application_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

