

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/App_Application_AfterIns.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: App_Application_AfterIns'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[App_Application_AfterIns]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[App_Application_AfterIns]
  delete from GXDBVersions where name = 'App_Application_AfterIns' and type = 6
END
GO

 GO
 SET QUOTED_IDENTIFIER ON
 GO
	CREATE TRIGGER App_Application_AfterIns
 	ON App_Application
	AFTER INSERT
	AS
	BEGIN
		IF @@ROWCOUNT = 0 RETURN			--If no rows updated
		SET NOCOUNT ON
		DECLARE @currentTime INTEGER
		SET 		@currentTime = dbo.GetUnixTime(GETUTCDATE())

		IF EXISTS (SELECT 1 FROM INSERTED WHERE dataArchGrpID > 1 OR  logArchGrpID > 1)
		BEGIN
				DECLARE @appIdsXML XML
				SET @appIdsXML =    (SELECT  DISTINCT aa.id AS 'subclient/@subclientId', AGC.id AS 'copy/@copyId' FROM INSERTED aa
												INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AG.id IN (aa.dataArchGrpID, aa.logArchGrpID) AND (dataArchGrpID > 1 OR logArchGrpID > 1)
												INNER JOIN archgroupCopy AGC WITH (READUNCOMMITTED) ON AGC.archgroupID IN (Ag.id, AG.incrSP)  AND  AGC.id > 0 AND AGC.dedupeFlags & 262144 > 0 /*CVA_SIDB_STORE_ENABLED_FLAG*/
											FOR XML PATH('subclientToCopyMaps'), root('App_ConfigureDDBMapForSubclients' ))

				exec AppSubmitXmlWQ @appIdsXML --proc to submit XML request for work queue
		END
	 END
 GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [App_Application_AfterIns]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'App_Application_AfterIns' AND revision = '1.1.2.4')

  insert into GXDBVersions values(6, 'App_Application_AfterIns',  '1.1.2.4', 'App_Application_AfterIns', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

