

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_SCGRuleScope.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_SCGRuleScope'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_SCGRuleScope]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_SCGRuleScope]
  delete from GXDBVersions where name = 'APP_SCGRuleScope' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_SCGRuleScope
ON APP_SCGRule
AFTER INSERT, UPDATE		-- no reason to come here on DELETE Ops which are handled by the Cascade Deletion operation
AS
BEGIN
	SET NOCOUNT ON
	-- Working on the assumption that there is still a 1 to 1 mapping for Client Group Scope.  Future Provider entities could be 1 to N mapping
	IF OBJECT_ID('TempDb..#Scope') IS NOT NULL
		DROP TABLE #Scope
	CREATE TABLE #Scope (
		scgRuleId	INT PRIMARY KEY,
		cgId		INT,
		userId		INT,
		isUpdate	TINYINT,		-- 0 inserted, 1 updated
		entityType	INT DEFAULT NULL,
		entityId	INT DEFAULT NULL
	)
	INSERT INTO #Scope (scgRuleId, cgId, userId, isUpdate)
		SELECT
			i.id,
			cg.id,
			cg.userId,
			0
		FROM INSERTED i
			INNER JOIN APP_ClientGroup cg WITH(NOLOCK) ON
				cg.id = i.scgId
		WHERE
			i.id NOT IN (SELECT d.id FROM DELETED d)		-- insert op
		UNION ALL
		SELECT
			i.id,
			cg.id,
			cg.userId,
			1
		FROM INSERTED i
			INNER JOIN APP_ClientGroup cg WITH(NOLOCK) ON
				cg.id = i.scgId
		WHERE
			i.id IN (SELECT d.id FROM DELETED d)		-- update op
	IF OBJECT_ID ('tempdb.dbo.#AdminUserAndGroupIds') IS NOT NULL
		DROP TABLE #AdminUserAndGroupIds
	CREATE TABLE #AdminUserAndGroupIds
	(
		isUser			INT,
		userOrgroupId	INT
	)
	CREATE CLUSTERED INDEX AdminUserAndGroupIds_isUser_userOrGroupId_Idx1 ON #AdminUserAndGroupIds (isUser, userOrGroupId);; -- this table might contain duplicates.
	-- Get all users and groups who have Agent management and Change Security setting on commcell.
	INSERT INTO #AdminUserAndGroupIds
		SELECT
			AgentManagement.isUser,
			AgentManagement.userOrGroupId
		FROM UMSecurityAssociations AgentManagement(NOLOCK)
			INNER JOIN UMSecurityAssociations ChangeSecuritySetting (NOLOCK) ON
				AgentManagement.isUser = ChangeSecuritySetting.isUser				-- Same user and group should have Agent Management and Change Security setting on Commcell.
				AND AgentManagement.userOrGroupId = ChangeSecuritySetting.userOrGroupId
				AND AgentManagement.entityType1 = 1						-- COMMCELL_ENTITY
				AND AgentManagement.entityId1 = 2						-- DEFAULT_COMMCELL_ID
				AND ChangeSecuritySetting.entityType1 = 1				-- COMMCELL_ENTITY
				AND ChangeSecuritySetting.entityId1 = 2					-- DEFAULT_COMMCELL_ID
				AND AgentManagement.permissionId = 2					-- EV_MANAGE_APPLICATION (Agent Management)
				AND ChangeSecuritySetting.permissionId = 107			-- CAT_MANAGE_ASSOC_ON_ENTITY (Change Security Setting)
		UNION
		SELECT
			AgentManagement.isUser,
			AgentManagement.userOrGroupId
		FROM UMSecurityAssociations AgentManagement(NOLOCK)
			INNER JOIN UMSecurityAssociations ChangeSecuritySetting (NOLOCK) ON
				AgentManagement.isUser = ChangeSecuritySetting.isUser				-- Same user and group should have Agent Management and Change Security setting on Commcell.
				AND AgentManagement.userOrGroupId = ChangeSecuritySetting.userOrGroupId
				AND AgentManagement.entityType1 = 1						-- COMMCELL_ENTITY
				AND AgentManagement.entityId1 = 2						-- DEFAULT_COMMCELL_ID
				AND ChangeSecuritySetting.entityType1 = 1				-- COMMCELL_ENTITY
				AND ChangeSecuritySetting.entityId1 = 2					-- DEFAULT_COMMCELL_ID
			INNER JOIN UMRolesWithPermissionsExpanded AgentManagementRole (NOLOCK) ON
				AgentManagement.roleId = AgentManagementRole.roleId
				AND AgentManagementRole.permissionId = 2
			INNER JOIN UMRolesWithPermissionsExpanded ChangeSecuritySettingRole (NOLOCK) ON
				ChangeSecuritySetting.roleId = ChangeSecuritySettingRole.roleId
				AND ChangeSecuritySettingRole.permissionId = 107
	-- Now expand the groups obtained above to their child groups and users. Since any of them might be set as owners so we want to treat them too as commcell admins.
	INSERT INTO #AdminUserAndGroupIds
		SELECT DISTINCT
			0,
			UDGM.umdsGroupID
		FROM #AdminUserAndGroupIds Admin
			INNER JOIN UMDSGroupMaps UDGM (NOLOCK) ON
				Admin.isUser = 0
				AND Admin.userOrgroupId = UDGM.umgroupId
	INSERT INTO #AdminUserAndGroupIds
		SELECT DISTINCT
			1,
			UG.userID
		FROM #AdminUserAndGroupIds Admin
			INNER JOIN UMUserGroup UG(NOLOCK) ON
				Admin.isUser = 0
				AND Admin.userOrGroupId = UG.groupId
	IF OBJECT_ID('TempDb..#Users') IS NOT NULL
		DROP TABLE #Users
	CREATE TABLE #Users (
		userId		INT,
		entityType	TINYINT,	-- Commcell Admin 1, Tenant Admin Provider 61
		providerId	INT NULL,	-- set for Tenant Admin
		PRIMARY KEY (userId, entityType)
	)
	INSERT INTO #Users (userId, entityType)
		SELECT
			s.userId,
			1		-- COMMCELL_ENTITY
		FROM #AdminUserAndGroupIds u
			INNER JOIN #Scope s ON
				u.isUser = 1
				AND s.userId = u.userOrgroupId
		GROUP BY
			s.userId
	DROP TABLE #AdminUserAndGroupIds
	INSERT INTO #Users (userId, entityType, providerId)
		-- currently only supporting a 1 to 1 mapping
		SELECT
			u.userId,
			61,		-- PROVIDER_ENTITY
			MIN(u.providerId) providerId		-- first assocated company id
		FROM (
				SELECT
					ug.userId,
					p.id providerId
				FROM UMUserGroup ug WITH(NOLOCK)
					INNER JOIN UMGroups g WITH(NOLOCK) ON
						ug.groupId = g.id
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						g.umdsProviderId = p.id
					INNER JOIN #Scope s ON
						s.userId = ug.userId
				WHERE
					(g.groupFlags & 0x10000) <> 0
				UNION
				SELECT
					ug.userId,
					p.id providerId
				FROM UMUserGroup ug WITH(NOLOCK)
					INNER JOIN UMDSGroupMaps gm WITH(NOLOCK) ON
						ug.groupId = gm.umdsgroupId
					INNER JOIN UMGroups g WITH(NOLOCK) ON
						gm.umGroupId = G.id
					INNER JOIN UMDSProviders p WITH(NOLOCK) ON
						g.umdsProviderId = p.id
					INNER JOIN #Scope s ON
						s.userId = ug.userId
				WHERE
					(g.groupFlags & 0x10000) <> 0
			) u
		GROUP BY
			u.userId
	UPDATE s
		SET entityType = (
				CASE
					-- For default setting, regular user not checking if the user has rights on User Group level like the SP
					-- does computing the highest user scope level that is sent up to the GUI for Scope Level user selection.
					-- So user scope is NOT promoted back up to User Group Scope in this case if rights do exists.
					-- The reason is because the user can change later, via GUI, to User Group if needed.
					WHEN u.userId IS NULL AND du.id IS NULL THEN 13				-- USER_ENTITY
					WHEN u.userId IS NULL AND du.id IS NOT NULL AND ug.groupId IS NOT NULL THEN	15	-- USERGROUP_ENTITY
					ELSE u.entityType
				END
			),
			entityId = (
				CASE
					WHEN u.userId IS NULL AND du.id IS NULL THEN s.userId				-- USER_ENTITY
					WHEN u.userId IS NULL AND du.id IS NOT NULL AND ug.groupId IS NOT NULL THEN ug.groupId	-- USERGROUP_ENTITY
					WHEN u.entityType = 61 THEN u.providerId							-- PROVIDER_ENTITY
					ELSE 2		-- COMMCELL_ENTITY default commserver Id
				END
			)
	FROM #Scope s
		LEFT OUTER JOIN #Users u ON
			u.userId = s.userId
		LEFT OUTER JOIN UMusers du WITH(NOLOCK) ON			-- NOT NULL Dummy User for UserGroup Owner
			du.id = s.userId
			AND (du.flags & 2048) = 2048					-- USERS_CREATE_AS_PER_USERGROUP
		LEFT OUTER JOIN (									-- NOT NULL UserGroup is owner of SCG
			SELECT
				ug.userId,
				ug.groupId,
				CASE
					WHEN p.id IS NULL THEN g.name
					ELSE P.domainName + '\' + g.name
				END name		-- require name since error were hidden user can be mapped to multiple groups
			FROM UMUserGroup ug WITH(NOLOCK)
				INNER JOIN UMGroups g WITH(NOLOCK) ON
					g.id = ug.groupId
				LEFT OUTER JOIN UMDSProviders p WITH(NOLOCK) ON
					g.umdsProviderId = p.id
		) ug ON
			ug.userId = du.id
			AND ug.name = du.name		-- make sure user and group name match to eliminate multiple groups mapped.
-- Trigger should not update existing rows if already set
--	UPDATE s
--		SET entityType = u.entityType,
--			entityId = u.entityId
--	FROM APP_SCGScope s
--		INNER JOIN #Scope u ON
--			u.scgRuleId = s.scgRuleId
--	WHERE
--		u.isUpdate = 1
--		AND (
--			u.entityType <> s.entityType
--			OR u.entityId <> s.entityId
--		)
	INSERT INTO APP_SCGScope (scgRuleId, entityType, entityId)
		SELECT
			s.scgRuleId,
			s.entityType,
			s.entityId
		FROM #Scope s
			LEFT OUTER JOIN APP_SCGScope cgs WITH(NOLOCK) ON
				cgs.scgRuleId = s.scgRuleId
				-- Want to match any row present not a specific row
				--AND cgs.entityType = s.entityType
				--AND cgs.entityId = s.entityId
		WHERE
			cgs.scgRuleId IS NULL	-- only add if not present
-- Insert new row if it does not exist, an existing manual client group can be changed to an automatice client group so have to hand update operations as well
--			AND s.isUpdate = 0
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_SCGRuleScope]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_SCGRuleScope' AND revision = '1.1.2.4')

  insert into GXDBVersions values(6, 'APP_SCGRuleScope',  '1.1.2.4', 'APP_SCGRuleScope', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

