

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_InstancePropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_InstancePropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_InstancePropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_InstancePropTableChange]
  delete from GXDBVersions where name = 'APP_InstancePropTableChange' and type = 6
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE TRIGGER [dbo].[APP_InstancePropTableChange]
    ON [dbo].[APP_InstanceProp]
    AFTER INSERT, UPDATE
    AS
    BEGIN
        SET NOCOUNT ON;
        DECLARE @InstPropTableId INT = 41 -- APP_InstanceProp table id
        DECLARE @specialPropFlag INT = 32 -- Special property flag, XML, comma separated, semicolon separated
        DECLARE @CV_CASSANDRA_JMX_CONFIG NVARCHAR(50) = 'Cassandra gateway configuration'
        IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
                ON ACP.tableId = @InstPropTableId AND ACP.attrPwdName = INS.attrName
                  AND ACP.cs_attrPwdName = CHECKSUM(@CV_CASSANDRA_JMX_CONFIG) AND INS.attrName = @CV_CASSANDRA_JMX_CONFIG)
        BEGIN
            DECLARE @jmxConnection TABLE(id INT, attrVal XML, passwordV5 NVARCHAR(MAX))
            INSERT INTO @jmxConnection
                        SELECT id, attrVal,
                            dbo.pswConvertV3ToV5(CONVERT(XML, attrVal).value('(/App_JMXConnection/userPassword/@password)[1]', 'NVARCHAR(MAX)'))
                        FROM INSERTED INS
                        WHERE INS.attrName = @CV_CASSANDRA_JMX_CONFIG
            UPDATE @jmxConnection SET attrVal.modify('replace value of (/App_JMXConnection/userPassword/@password)[1] with sql:column("passwordV5")')
            UPDATE AI SET attrVal = CONVERT(NVARCHAR(MAX), A.attrVal)
                FROM APP_InstanceProp AI JOIN @jmxConnection A ON AI.id = A.id
        END
        DECLARE @CV_CASSANDRA_AUTH_CONFIG NVARCHAR(50) = 'Cassandra Authentication Configurations'
        IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
                ON ACP.tableId = @InstPropTableId AND ACP.attrPwdName = INS.attrName
                  AND ACP.cs_attrPwdName = CHECKSUM(@CV_CASSANDRA_AUTH_CONFIG) AND INS.attrName = @CV_CASSANDRA_AUTH_CONFIG)
        BEGIN
            DECLARE @authConfig TABLE(id INT, attrVal XML, keyStorePasswordV5 NVARCHAR(MAX), trustStorePasswordV5 NVARCHAR(MAX))
            INSERT INTO  @authConfig
                        SELECT id, attrVal,
                            dbo.pswConvertV3ToV5(CONVERT(XML, attrVal).value('(/App_AuthConfig/sslConfig/@keyStorePass)[1]', 'NVARCHAR(MAX)')),
                            dbo.pswConvertV3ToV5(CONVERT(XML, attrVal).value('(/App_AuthConfig/sslConfig/@trustStorePass)[1]', 'NVARCHAR(MAX)'))
                        FROM INSERTED INS
                        WHERE INS.attrName = @CV_CASSANDRA_AUTH_CONFIG
            UPDATE @authConfig SET attrVal.modify('replace value of (/App_AuthConfig/sslConfig/@keyStorePass)[1] with sql:column("keyStorePasswordV5")')
            UPDATE @authConfig SET attrVal.modify('replace value of (/App_AuthConfig/sslConfig/@trustStorePass)[1] with sql:column("trustStorePasswordV5")')
            UPDATE AI SET attrVal = CONVERT(NVARCHAR(MAX), A.attrVal)
                FROM APP_InstanceProp AI JOIN @authConfig A ON AI.id = A.id
        END
        IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
                    ON ACP.tableId = @InstPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND (ACP.flags & @specialPropFlag) != @specialPropFlag)
        BEGIN
            UPDATE AI SET attrVal = dbo.pswConvertV3ToV5(AI.attrVal) FROM APP_InstanceProp AI JOIN INSERTED INS
                ON AI.id = INS.id
            JOIN APP_CredProps ACP WITH(NOLOCK)
                ON ACP.tableId = @InstPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND (ACP.flags & @specialPropFlag) != @specialPropFlag
        END
    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_InstancePropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_InstancePropTableChange' AND revision = '1.1.2.7')

  insert into GXDBVersions values(6, 'APP_InstancePropTableChange',  '1.1.2.7', 'APP_InstancePropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

