

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_IDAPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_IDAPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_IDAPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_IDAPropTableChange]
  delete from GXDBVersions where name = 'APP_IDAPropTableChange' and type = 6
END
GO

	CREATE TRIGGER [dbo].[APP_IDAPropTableChange]
	ON [dbo].[APP_IDAProp]
	AFTER INSERT, UPDATE
	AS
	BEGIN
	SET NOCOUNT ON;
    --Convert password to v5 if any password properties values are updated
	DECLARE @IDAPropTableId INT = 31 -- APP_IDAProp table id
	DECLARE @specialPropFlag INT = 32 -- Special property flag, XML, comma separated, semicolon separated
	DECLARE @CV_PROP_EXCHANGE_AZURE_CONNECTIONS NVARCHAR(50) = 'Exchange Azure Connections'
	IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
					ON ACP.tableId = @IDAPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND INS.attrName = @CV_PROP_EXCHANGE_AZURE_CONNECTIONS )
	BEGIN
		DECLARE @INSERTED1 TABLE (id INT, attrName NVARCHAR(100), attrVal XML)
		DECLARE @XMLAzureConnections TABLE (id INT, azureAppId NVARCHAR(256), azureAppKeyValue  NVARCHAR(MAX),  azureDirectoryId NVARCHAR(256), azureAppDisplayName NVARCHAR(256), isCVCreated BIT,
                actualLength INT, resourceUri NVARCHAR(MAX), generatedTime  BIGINT, appStatus INT, type INT)
		DECLARE @XMLAzureRefreshToken TABLE (id INT, azureAppId NVARCHAR(256),  aValue NVARCHAR(MAX), aindex INT, alength INT)
		--REPLACE UTF-8 to UTF-16 is required as the value is stored with encoding UTF-8 i.e.<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
		INSERT INTO @INSERTED1 (id, attrName, attrVal) SELECT INS.id, attrName, REPLACE(attrVal, 'UTF-8', 'UTF-16')FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
            ON ACP.tableId = @IDAPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND INS.attrName = @CV_PROP_EXCHANGE_AZURE_CONNECTIONS
        INSERT INTO @XMLAzureConnections(id, azureAppId, azureAppKeyValue, azureDirectoryId, azureAppDisplayName, isCVCreated, actualLength, resourceURI, generatedTime, appStatus, type)
        SELECT
            id,
            ISNULL(dt.value('@azureAppId','NVARCHAR(256)'),'') azureAppId,
            ISNULL(dt.value('@azureAppKeyValue','NVARCHAR(MAX)'),'') azureAppKeyValue,
            dt.value('@azureDirectoryId','NVARCHAR(256)') azureDirectoryId,
            dt.value('@azureAppDisplayName','NVARCHAR(MAX)') azureAppDisplayName,
            dt.value('@isCVCreated','BIT') isCVCreated,
			dt.value('refreshToken[1]/@actualLength','INT') actualLength,
            dt.value('refreshToken[1]/@resourceUri','NVARCHAR(MAX)') resourceUri,
            dt.value('refreshToken[1]/@generatedTime','BIGINT') generatedTime,
            dt.value('@appStatus', 'INT') appStatus,
            dt.value('@type', 'INT') type
        FROM @INSERTED1 INS
            CROSS APPLY INS.attrVal.nodes('App_Office365AzureConnections/azureApps') D(dt)
		INSERT INTO @XMLAzureRefreshToken(id, azureAppId, aValue, aindex, alength)
        SELECT
            ISNULL(INS.id,'') azureAppId,
			dt.value('@azureAppId', 'NVARCHAR(MAX)'),
			dt2.value('@value','NVARCHAR(MAX)') aValue,
            dt2.value('@index','INT') aindex,
            dt2.value('@length','INT') alength
        FROM @INSERTED1 INS
			CROSS APPLY INS.attrVal.nodes('/App_Office365AzureConnections/azureApps') D(dt)
            CROSS APPLY D.dt.nodes('refreshToken') D1(dt1)
			CROSS APPLY D1.dt1.nodes('tokenValue') D2(dt2)
		UPDATE AI SET attrVal = CONVERT(NVARCHAR(MAX), R.attrVal)
		FROM  APP_IDAProp AI JOIN
		(SELECT id,
			CAST((SELECT
					(SELECT T2.azureAppId '@azureAppId', dbo.pswConvertV3ToV5(T2.azureAppKeyValue) '@azureAppKeyValue', T2.azureDirectoryId '@azureDirectoryId', T2.azureAppDisplayName '@azureAppDisplayName',
						T2.isCVCreated '@isCVCreated', T2.appStatus '@appStatus', T2.type '@type',
						(
							SELECT T2.generatedTime '@generatedTime', T2.actualLength '@actualLength', T2.resourceUri '@resourceUri',
							(SELECT  T3.aindex '@index', T3.alength '@length', dbo.pswConvertV3ToV5(T3.aValue) '@value'
									FROM @XMLAzureRefreshToken T3
									WHERE T3.id = T1.id AND T3.azureAppId = T2.azureAppId
									FOR XML PATH ('tokenValue'), TYPE
							)
							FOR XML PATH ('refreshToken'),TYPE
						)
						FROM @XMLAzureConnections T2
						WHERE T1.id = T2.id
							FOR XML PATH ('azureApps'), TYPE
				)
			FROM  @XMLAzureConnections T1
			WHERE T1.id = T.id
			GROUP BY T1.id
				FOR XML PATH(''),
				ROOT('App_Office365AzureConnections')) AS XML) AS attrVal
			FROM  @XMLAzureConnections T
			GROUP BY T.id) R
				ON AI.id = R.id
	END
	DECLARE @CV_EXCH_ONEPASS_ADMIN_ACCNT NVARCHAR(50) = 'Exchange OnePass Admin Accounts'
	IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
					ON ACP.tableId = @IDAPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND INS.attrName = @CV_EXCH_ONEPASS_ADMIN_ACCNT )
	BEGIN
		DECLARE @INSERTED2 TABLE (id INT, attrName NVARCHAR(100), attrVal XML)
		DECLARE @XMLAdminAccounts TABLE (id INT, userName NVARCHAR(256), password  NVARCHAR(MAX),  domainName NVARCHAR(256), confirmPassword NVARCHAR(MAX), exchangeAdminSmtpAddress NVARCHAR(256), profileName NVARCHAR(MAX), SerType int, status INT)
		--REPLACE UTF-8 to UTF-16 is required as the value is stored with encoding UTF-8 i.e.<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
		INSERT INTO @INSERTED2 (id, attrName, attrVal) SELECT INS.id, attrName, REPLACE(attrVal, 'UTF-8', 'UTF-16')FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
			ON ACP.tableId = @IDAPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND INS.attrName = @CV_EXCH_ONEPASS_ADMIN_ACCNT
		INSERT INTO @XMLAdminAccounts(id, userName, password,  domainName, confirmPassword, exchangeAdminSmtpAddress, profileName, SerType, status)
		SELECT
			id,
			ISNULL(dt.value('userAccount[1]/@userName','NVARCHAR(256)'),'') userName,
			ISNULL(dt.value('userAccount[1]/@password','NVARCHAR(MAX)'),'') password,
			dt.value('userAccount[1]/@domainName','NVARCHAR(256)'),
			dt.value('userAccount[1]/@confirmPassword','NVARCHAR(MAX)'),
			ISNULL(dt.value('@exchangeAdminSmtpAddress','NVARCHAR(MAX)'),'') exchangeAdminSmtpAddress,
			dt.value('@profileName','NVARCHAR(MAX)') profileName,
			ISNULL(dt.value('@serviceType','INT'),'') SerType,
			ISNULL(dt.value('@status', 'INT'), '') status
		FROM @INSERTED2 INS
			CROSS APPLY INS.attrVal.nodes('App_ExchangeAdminAccounts/adminAccounts') D(dt)
		UPDATE AI SET attrVal = CONVERT(NVARCHAR(MAX), R.attrVal)
		FROM  APP_IDAProp AI JOIN
			(SELECT id,
			CAST((SELECT
					(SELECT T2.exchangeAdminSmtpAddress '@exchangeAdminSmtpAddress', T2.SerType '@serviceType', T2.status '@status', T2.profileName '@profileName',
						(
							SELECT T2.userName '@userName', dbo.pswConvertV3ToV5(T2.password) '@password', T2.domainName '@domainName', dbo.pswConvertV3ToV5(T2.confirmPassword) '@confirmPassword'
							FOR XML PATH ('userAccount'),TYPE
						)
						FROM @XMLAdminAccounts T2
						WHERE T1.id = T2.id
							FOR XML PATH ('adminAccounts'), TYPE
				)
			FROM  @XMLAdminAccounts T1
			WHERE T1.id = T.id
			GROUP BY T1.id
				FOR XML PATH(''),
				ROOT('App_ExchangeAdminAccounts')) AS XML) AS attrVal
			FROM  @XMLAdminAccounts T
			GROUP BY T.id) R
				ON AI.id = R.id
	END
	IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
						ON ACP.tableId = @IDAPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND (ACP.flags & @specialPropFlag) != @specialPropFlag)
	BEGIN
		UPDATE AIP SET attrVal = dbo.pswConvertV3ToV5(AIP.attrVal) FROM APP_IDAProp AIP JOIN INSERTED INS
			ON AIP.id = INS.id
		JOIN APP_CredProps ACP WITH(NOLOCK)
			ON ACP.tableId = @IDAPropTableId AND ACP.attrPwdName = INS.attrName	AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND (ACP.flags & @specialPropFlag) != @specialPropFlag
	END
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_IDAPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_IDAPropTableChange' AND revision = '1.1.2.7.8.1')

  insert into GXDBVersions values(6, 'APP_IDAPropTableChange',  '1.1.2.7.8.1', 'APP_IDAPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

