

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CompanyPropAttrValInt.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CompanyPropAttrValInt'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CompanyPropAttrValInt]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CompanyPropAttrValInt]
  delete from GXDBVersions where name = 'APP_CompanyPropAttrValInt' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_CompanyPropAttrValInt
	ON APP_CompanyProp
	AFTER INSERT, UPDATE
AS
BEGIN
	SET NOCOUNT ON
	IF EXISTS (
		SELECT
			1
		FROM INSERTED i
		WHERE
			i.attrType in (
				5,	--PROPERTY_SHORT
				6,	--PROPERTY_USHORT
				7,	--PROPERTY_INTEGER
				8,	--PROPERTY_UINTEGER
				9,	--PROPERTY_LONG
				10	--PROPERTY_ULONG
			)
			AND LEN(i.attrVal) <= 10		-- largest integer string possible
			AND ISNUMERIC(i.attrVal) = 1
			AND i.attrValInt <> TRY_CAST(i.attrVal AS INTEGER)
	)
	BEGIN
		UPDATE cp
			SET attrValInt = CAST(i.attrVal AS INTEGER)
		FROM APP_CompanyProp cp
			INNER JOIN INSERTED i ON
				i.id = cp.id
		WHERE
			i.attrType in (
				5,	--PROPERTY_SHORT
				6,	--PROPERTY_USHORT
				7,	--PROPERTY_INTEGER
				8,	--PROPERTY_UINTEGER
				9,	--PROPERTY_LONG
				10	--PROPERTY_ULONG
			)
			AND LEN(i.attrVal) <= 10		-- largest integer string possible
			AND ISNUMERIC(i.attrVal) = 1
			AND i.attrValInt <> TRY_CAST(i.attrVal AS INTEGER)
	END
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CompanyPropAttrValInt]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CompanyPropAttrValInt' AND revision = '1.1.2.1')

  insert into GXDBVersions values(6, 'APP_CompanyPropAttrValInt',  '1.1.2.1', 'APP_CompanyPropAttrValInt', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

