

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_Client_AfterUpd.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_Client_AfterUpd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_Client_AfterUpd]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_Client_AfterUpd]
  delete from GXDBVersions where name = 'APP_Client_AfterUpd' and type = 6
END
GO

 SET QUOTED_IDENTIFIER ON
	GO
	CREATE TRIGGER APP_Client_AfterUpd
	ON APP_Client AFTER UPDATE
	AS
	SET NOCOUNT ON
	BEGIN
	IF @@ROWCOUNT > 0 AND UPDATE(net_hostname)
	BEGIN
		UPDATE edcClientNameMap
			SET gxMachineHostName = I.net_hostname
			FROM edcClientNameMap e, inserted I, deleted D
		WHERE
			e.gxMachineHostName = D.net_hostname AND D.id = I.id
	END

	--Insert client upgrade Time
	IF UPDATE(releaseId)
	BEGIN
		DECLARE @currentTime INTEGER = dbo.GetUnixTime(GetUTCDate())
		BEGIN
			MERGE APP_CLIENTPROP P
			USING
			(
				SELECT i.id
				FROM
				INSERTED i JOIN DELETED d
				ON i.id = d.id and i.releaseId <> d.releaseId

			) AS T ON T.id = P.componentnameId AND P.attrName = 'Client Upgrade Time'
			WHEN MATCHED  THEN
				UPDATE SET attrval = @currentTime
			WHEN NOT MATCHED  THEN
				INSERT (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
				VALUES (T.id,'Client Upgrade Time',2,@currentTime,@currentTime,0,0);
		END
	END
	SET NOCOUNT OFF
	END
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_Client_AfterUpd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_Client_AfterUpd' AND revision = '1.5.12.2')

  insert into GXDBVersions values(6, 'APP_Client_AfterUpd',  '1.5.12.2', 'APP_Client_AfterUpd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

