

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_ClientPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_ClientPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_ClientPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_ClientPropTableChange]
  delete from GXDBVersions where name = 'APP_ClientPropTableChange' and type = 6
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE TRIGGER [dbo].[APP_ClientPropTableChange]
	ON [dbo].[App_ClientProp]
	AFTER INSERT, UPDATE
	AS
	BEGIN
		SET NOCOUNT ON;
        --Convert password to v5 if any password properties values are updated
		DECLARE @ClientPropTableId INT = 21 -- APP_ClientProp table id
		DECLARE @specialPropFlag INT = 32 -- Special property flag, XML, comma separated, semicolon separated
		IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
							ON ACP.tableId = @ClientPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName))
		BEGIN
			UPDATE AC SET attrVal = dbo.pswConvertV3ToV5(AC.attrVal) FROM App_ClientProp AC JOIN INSERTED INS
				ON AC.id = INS.id
			JOIN APP_CredProps ACP WITH(NOLOCK)
				ON ACP.tableId = @ClientPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName) AND (ACP.flags & @specialPropFlag) != @specialPropFlag
			DECLARE @CV_CLOUD_APPS_CRED NVARCHAR(50) = 'Cloud Apps Credentials'
			IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
						ON ACP.tableId = @ClientPropTableId AND ACP.attrPwdName = INS.attrName
						AND ACP.cs_attrPwdName = CHECKSUM(@CV_CLOUD_APPS_CRED) AND INS.attrName = @CV_CLOUD_APPS_CRED)
			BEGIN
				DECLARE @cloudApps TABLE(id INT, attrVal XML, passwordV5 NVARCHAR(MAX))
				INSERT INTO @cloudApps
							SELECT INS.id, attrVal,
								dbo.pswConvertV3ToV5(
								CASE WHEN CONVERT(XML, attrVal).value('(/App_AzureResourceManager/credentials/@password)[1]', 'NVARCHAR(MAX)') IS NOT NULL
									THEN CONVERT(XML, attrVal).value('(/App_AzureResourceManager/credentials/@password)[1]', 'NVARCHAR(MAX)')
									WHEN CONVERT(XML, attrVal).value('(/App_AmazonInstanceInfo/@secretkey)[1]', 'NVARCHAR(MAX)') IS NOT NULL
									THEN CONVERT(XML, attrVal).value('(/App_AmazonInstanceInfo/@secretkey)[1]', 'NVARCHAR(MAX)')
								END)
							FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
								ON ACP.tableId = @ClientPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(@CV_CLOUD_APPS_CRED) AND INS.attrName = @CV_CLOUD_APPS_CRED
				UPDATE @cloudApps SET attrVal.modify('replace value of (/App_AzureResourceManager/credentials/@password)[1] with sql:column("passwordV5")')
				UPDATE @cloudApps SET attrVal.modify('replace value of (/App_AmazonInstanceInfo/@secretkey)[1] with sql:column("passwordV5")')
				UPDATE AI SET attrVal = CONVERT(NVARCHAR(MAX), A.attrVal)
					FROM APP_ClientProp AI JOIN @cloudApps A ON AI.id = A.id
			END
		END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_ClientPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_ClientPropTableChange' AND revision = '1.1.2.7')

  insert into GXDBVersions values(6, 'APP_ClientPropTableChange',  '1.1.2.7', 'APP_ClientPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

