

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_ClientInstallHistoryInsert.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_ClientInstallHistoryInsert'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_ClientInstallHistoryInsert]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_ClientInstallHistoryInsert]
  delete from GXDBVersions where name = 'APP_ClientInstallHistoryInsert' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_ClientInstallHistoryInsert
ON APP_Client
AFTER INSERT
AS
BEGIN
	DECLARE @localTime INT = dbo.GetUnixTime(GetUTCDate())
	INSERT INTO APP_ClientInstallHistory (clientId, installTime, uninstallTime)
	SELECT id, @localTime, 0 FROM INSERTED
	UPDATE A
	SET A.displayName = A.name
	FROM APP_Client A
		INNER JOIN INSERTED B
			ON A.id = B.id
	WHERE B.displayName = 'REPLACEWITHCLIENTNAME'
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_ClientInstallHistoryInsert]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_ClientInstallHistoryInsert' AND revision = '1.7.76.1')

  insert into GXDBVersions values(6, 'APP_ClientInstallHistoryInsert',  '1.7.76.1', 'APP_ClientInstallHistoryInsert', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

