

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_ClientGroupSCGScopeOwnerUpdated.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_ClientGroupSCGScopeOwnerUpdated'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_ClientGroupSCGScopeOwnerUpdated]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_ClientGroupSCGScopeOwnerUpdated]
  delete from GXDBVersions where name = 'APP_ClientGroupSCGScopeOwnerUpdated' and type = 6
END
GO

CREATE TRIGGER APP_ClientGroupSCGScopeOwnerUpdated
	ON APP_ClientGroup
	AFTER UPDATE
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @rcnt INT = 0
	DECLARE @cgOwnersChanged TABLE (
		cgId		INT PRIMARY KEY,
		ruleId		INT,
		userId		INT,
		isGroup		TINYINT,
		oldUserId	INT,
		isOldGroup	TINYINT,
		scopeType	INT,
		scopeId		INT
	)
	-- Determine if userId column has been changed, if not nothing to do
	INSERT INTO @cgOwnersChanged (cgId, ruleId, userId, isGroup, oldUserId, isOldGroup, scopeType, scopeId)
		SELECT
			i.id,
			r.id,
			i.userId,
			CASE
				WHEN (nu.flags & 2048) = 2048 THEN 1		-- USERS_CREATE_AS_PER_USERGROUP
				ELSE 0
			END,
			d.userId,
			CASE
				WHEN ou.flags IS NULL THEN 0
				WHEN (ou.flags & 2048) = 2048 THEN 1		-- USERS_CREATE_AS_PER_USERGROUP
				ELSE 0
			END,
			s.entityType,
			s.entityId
		FROM INSERTED i
			INNER JOIN DELETED d ON
				i.id = d.id				-- is an UPDATE Op
			INNER JOIN APP_SCGRule r WITH(NOLOCK) ON
				r.scgId = i.id			-- only want SCG associations
			INNER JOIN APP_SCGScope s WITH(NOLOCK) ON
				s.scgRuleId = r.id
			INNER JOIN UMUsers nu WITH(NOLOCK) ON
				nu.id = i.userId
			LEFT OUTER JOIN UMusers ou WITH(NOLOCK) ON		-- old user id could be deleted at this point since there is no FK enforcement in place on the APP_ClientGroup table.
				ou.id = d.userId
		WHERE
			i.userId <> d.userId			-- was client group owner changed?
			AND s.entityType IN (13, 15)	-- USER_ENTITY, USERGROUP_ENTITY: not changing scope setting if already set to Commcelll (1) or Company (61)
	SET @rcnt = @@ROWCOUNT
	IF (@rcnt > 0)
	BEGIN
		-- No longer computing highest scope based on new owner userId by default.
		-- Change Scope if user entity type and id match old owner userId to new userId.
		-- Only handling direct mappings now.
		UPDATE s
			SET entityId = c.userId
		FROM APP_SCGScope s
			INNER JOIN @cgOwnersChanged c ON
				c.ruleId = s.scgRuleId
		WHERE
			(
				c.isGroup = 0					-- is user
				AND c.isOldGroup = 0
				AND c.scopeType = 13			-- current set scope is USER_ENTITY
				AND c.scopeId = c.oldUserId		-- old userId matches so change scope to new userId
			)
			OR (
				c.isGroup = 1					-- is user group
				AND c.isOldGroup = 1
				AND c.scopeType = 15			-- current set scope is USERGROUP_ENTITY
				AND c.scopeId = c.oldUserId		-- old group userId matches so change scope to new group userId
			)
	END
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_ClientGroupSCGScopeOwnerUpdated]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_ClientGroupSCGScopeOwnerUpdated' AND revision = '1.1.4.3')

  insert into GXDBVersions values(6, 'APP_ClientGroupSCGScopeOwnerUpdated',  '1.1.4.3', 'APP_ClientGroupSCGScopeOwnerUpdated', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

