

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_ClientGroupAssocTable.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_ClientGroupAssocTable'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_ClientGroupAssocTable]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_ClientGroupAssocTable]
  delete from GXDBVersions where name = 'APP_ClientGroupAssocTable' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_ClientGroupAssocTable
ON APP_ClientGroupAssoc
AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	SET NOCOUNT ON
	DECLARE	@currentTime INT = dbo.GetUnixTime(GetDate()) -- Since the one in TM_assocEntity uses Getdate unixtime.
	DECLARE	@utcTime INT = dbo.GetUnixTime(GETUTCDATE())
	IF OBJECT_ID('HistoryDB..Audit_ClientGroupAssoc') IS NOT NULL
	BEGIN
		-- Archiving require Client Group Association Auditing History which is stored in the HistoryDb
		INSERT INTO APP_ClientGroupAssocTrigger (clientGroupId, clientId, createdTime, opType)
			OUTPUT INSERTED.clientGroupId, INSERTED.clientId, @utcTime, (CASE INSERTED.opType WHEN 2 THEN 0 WHEN 3 THEN 1 ELSE 2 END)
				INTO HistoryDB..Audit_ClientGroupAssoc (clientGroupId, clientId, createdTime, opType)
			SELECT
				i.clientGroupId, i.clientId, @currentTime, 2
			FROM
				INSERTED i
				LEFT OUTER JOIN DELETED d
					ON i.clientId = d.clientId
						AND i.clientGroupId = d.clientGroupId
				LEFT OUTER JOIN App_CompanyEntities App
					ON App.entityType = 3 AND App.entityId = i.clientId  -- client entity
			WHERE
				d.clientId IS NULL	-- new rows inserted
				AND (App.flags is null OR  App.flags & 0x2 = 0)  --  CV_STATUS_ENTITY_SCHEDULED_TO_BE_DELETED
			UNION ALL
			SELECT
				d.clientGroupId, d.clientId, @currentTime, 3
			FROM
				DELETED d
				LEFT OUTER JOIN INSERTED i
					ON d.clientId = i.clientId
						AND d.clientGroupId = i.clientGroupId
				LEFT OUTER JOIN App_CompanyEntities App
					ON App.entityType = 3 AND App.entityId = d.clientId  -- client entity
			WHERE
				i.clientId IS NULL	-- existing rows deleted
				AND (App.flags is null OR  App.flags & 0x2 = 0)  --  CV_STATUS_ENTITY_SCHEDULED_TO_BE_DELETED
	END
	ELSE
	BEGIN
		INSERT INTO APP_ClientGroupAssocTrigger (clientGroupId, clientId, createdTime, opType)
			SELECT
				i.clientGroupId, i.clientId, @currentTime, 2
			FROM
				INSERTED i
				LEFT OUTER JOIN DELETED d
					ON i.clientId = d.clientId
						AND i.clientGroupId = d.clientGroupId
				LEFT OUTER JOIN App_CompanyEntities App
					ON App.entityType = 3 AND App.entityId = i.clientId  -- client entity
			WHERE
				d.clientId IS NULL	-- new rows inserted
				AND (App.flags is null OR  App.flags & 0x2 = 0)  --  CV_STATUS_ENTITY_SCHEDULED_TO_BE_DELETED
			UNION ALL
			SELECT
				d.clientGroupId, d.clientId, @currentTime, 3
			FROM
				DELETED d
				LEFT OUTER JOIN INSERTED i
					ON d.clientId = i.clientId
						AND d.clientGroupId = i.clientGroupId
				LEFT OUTER JOIN App_CompanyEntities App
					ON App.entityType = 3 AND App.entityId = d.clientId  -- client entity
			WHERE
				i.clientId IS NULL	-- existing rows deleted
				AND (App.flags is null OR  App.flags & 0x2 = 0)  --  CV_STATUS_ENTITY_SCHEDULED_TO_BE_DELETED
	END
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_ClientGroupAssocTable]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_ClientGroupAssocTable' AND revision = '1.1.2.5')

  insert into GXDBVersions values(6, 'APP_ClientGroupAssocTable',  '1.1.2.5', 'APP_ClientGroupAssocTable', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

