

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSSubClientPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSSubClientPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSSubClientPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSSubClientPropTableChange]
  delete from GXDBVersions where name = 'APP_CCSSubClientPropTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSSubClientPropTableChange
	ON APP_SubClientProp
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 5		-- APP_SubClientProp Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = i.componentNameId
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = a.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = i.componentNameId
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = a.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = d.componentNameId
	--				INNER JOIN APP_ClientProp cp WITH (NOLOCK)
	--					ON cp.componentNameId = a.clientId
	--						AND cp.modified = 0
	--						AND cp.attrName = 'CCS Enabled'
	--						AND cp.attrVal = '1'
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSSubClientPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSSubClientPropTableChange' AND revision = '1.6.52.1')

  insert into GXDBVersions values(6, 'APP_CCSSubClientPropTableChange',  '1.6.52.1', 'APP_CCSSubClientPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

