

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSScFilterFileTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSScFilterFileTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSScFilterFileTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSScFilterFileTableChange]
  delete from GXDBVersions where name = 'APP_CCSScFilterFileTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSScFilterFileTableChange
	ON APP_ScFilterFile
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 17		-- APP_ScFilterFile Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = i.componentNameId
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = i.componentNameId
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.id = d.componentNameId
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSScFilterFileTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSScFilterFileTableChange' AND revision = '1.3.52.1')

  insert into GXDBVersions values(6, 'APP_CCSScFilterFileTableChange',  '1.3.52.1', 'APP_CCSScFilterFileTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

