

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSPlatformTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSPlatformTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSPlatformTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSPlatformTableChange]
  delete from GXDBVersions where name = 'APP_CCSPlatformTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSPlatformTableChange
	ON APP_Platform
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 3		-- APP_Platform Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1, rowId2)
			SELECT
					CASE WHEN i.clientId = 2 THEN @AllClients ELSE i.clientId END,		-- If CS Client Id then ship to all CCS Clients
					@TableType, 0, @currentTime, i.clientId, i.platformType
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.platformType = d.platformType
				WHERE
					d.clientId IS NULL	-- new rows inserted
			UNION
			SELECT
					CASE WHEN i.clientId = 2 THEN @AllClients ELSE i.clientId END,		-- If CS Client Id then ship to all CCS Clients
					@TableType, 1, @currentTime, i.clientId, i.platformType
				FROM
					INSERTED i
					INNER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.platformType = d.platformType	-- updated rows
			UNION
			SELECT
					CASE WHEN d.clientId = 2 THEN @AllClients ELSE d.clientId END,		-- If CS Client Id then ship to all CCS Clients
					@TableType, 2, @currentTime, d.clientId, d.platformType
				FROM
					DELETED d
					LEFT OUTER JOIN INSERTED i
						ON d.clientId = i.clientId
							AND d.platformType = i.platformType
				WHERE
					i.clientId IS NULL	-- existing rows deleted

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSPlatformTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSPlatformTableChange' AND revision = '1.6.52.2')

  insert into GXDBVersions values(6, 'APP_CCSPlatformTableChange',  '1.6.52.2', 'APP_CCSPlatformTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

