

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSJobErrorDecisionRuleTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSJobErrorDecisionRuleTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSJobErrorDecisionRuleTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSJobErrorDecisionRuleTableChange]
  delete from GXDBVersions where name = 'APP_CCSJobErrorDecisionRuleTableChange' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_CCSJobErrorDecisionRuleTableChange
ON APP_JobErrorDecisionRule
AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	SET NOCOUNT ON
	-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
	-- with the CCM Data being inserted into the Commserv Database
	IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
	BEGIN
		RETURN;
	END
	DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
	DECLARE @TableType INT = 25		-- APP_JobErrorDecisionRule Table Type
	DECLARE @AllClients INT = -1	-- When EntityType = 1 and EntityId 2
	INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
		-- CommCell
		SELECT
				@AllClients, @TableType, 0, @currentTime, i.id
			FROM
				INSERTED i
			WHERE
				i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
				AND i.entityType = 1	-- Commcell Entity Type
				AND i.entityId = 2		-- CSId
		UNION
		SELECT
				@AllClients, @TableType, 1, @currentTime, i.id
			FROM
				INSERTED i
			WHERE
				i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
				AND i.entityType = 1	-- Commcell Entity Type
				AND i.entityId = 2		-- CSId
		UNION
		SELECT
				@AllClients, @TableType, 2, @currentTime, d.id
			FROM
				DELETED d
			WHERE
				d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
				AND d.entityType = 1	-- Commcell Entity Type
				AND d.entityId = 2		-- CSId
		UNION	-- Client
		SELECT
				i.entityId, @TableType, 0, @currentTime, i.id
			FROM
				INSERTED i
			WHERE
				i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
				AND i.entityType = 3	-- Client Entity Type
		UNION
		SELECT
				i.entityId, @TableType, 1, @currentTime, i.id
			FROM
				INSERTED i
			WHERE
				i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
				AND i.entityType = 3	-- Client Entity Type
		UNION
		SELECT
				d.entityId, @TableType, 2, @currentTime, d.id
			FROM
				DELETED d
			WHERE
				d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
				AND d.entityType = 3	-- Client Entity Type
		UNION	-- ClientGroup
		SELECT
				ag.clientId, @TableType, 0, @currentTime, i.id		-- map to clients in the clientgroup
			FROM
				INSERTED i
				INNER JOIN APP_ClientGroupAssoc ag WITH(NOLOCK) ON
					i.entityType = 28	-- ClientGroup Entity Type
					AND i.entityId = ag.clientGroupId
			WHERE
				i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
		UNION
		SELECT
				ag.clientId, @TableType, 1, @currentTime, i.id		-- map to clients in the clientgroup
			FROM
				INSERTED i
				INNER JOIN APP_ClientGroupAssoc ag WITH(NOLOCK) ON
					i.entityType = 28	-- ClientGroup Entity Type
					AND i.entityId = ag.clientGroupId
			WHERE
				i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
		UNION
		SELECT
				ag.clientId, @TableType, 2, @currentTime, d.id		-- map to clients in the clientgroup
			FROM
				DELETED d
				INNER JOIN APP_ClientGroupAssoc ag WITH(NOLOCK) ON
					d.entityType = 28	-- ClientGroup Entity Type
					AND d.entityId = ag.clientGroupId
			WHERE
				d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSJobErrorDecisionRuleTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSJobErrorDecisionRuleTableChange' AND revision = '1.1.48.2')

  insert into GXDBVersions values(6, 'APP_CCSJobErrorDecisionRuleTableChange',  '1.1.48.2', 'APP_CCSJobErrorDecisionRuleTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

