

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSInstFilterFileTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSInstFilterFileTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSInstFilterFileTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSInstFilterFileTableChange]
  delete from GXDBVersions where name = 'APP_CCSInstFilterFileTableChange' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_CCSInstFilterFileTableChange
ON APP_InstFilterFile
AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	SET NOCOUNT ON
	-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
	-- with the CCM Data being inserted into the Commserv Database
	IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
	BEGIN
		RETURN;
	END
	DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
	DECLARE @TableType INT = 16		-- APP_InstFilterFile Table Type
	INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
		SELECT
				a.clientId, @TableType, 0, @currentTime, i.id
			FROM
				INSERTED i
				INNER JOIN APP_Application a  WITH (NOLOCK)
					ON a.instance = i.componentNameId
			WHERE
				i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
		UNION
		SELECT
				a.clientId, @TableType, 1, @currentTime, i.id
			FROM
				INSERTED i
				INNER JOIN APP_Application a  WITH (NOLOCK)
					ON a.instance = i.componentNameId
			WHERE
				i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
		UNION
		SELECT
				aa.clientId, @TableType, 2, @currentTime, d.id
			FROM
				DELETED d
				-- Use the Deletion Audit Application Table instead will have a row whereas the APP_Application Table may not.
				--INNER JOIN APP_Application a  WITH (READUNCOMMITTED)
				--	ON a.instance = d.componentNameId
				INNER JOIN APP_CCSApplicationDelAudit aa  WITH (READUNCOMMITTED)
					ON aa.instanceId = d.componentNameId
			WHERE
				d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSInstFilterFileTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSInstFilterFileTableChange' AND revision = '1.4.12.2')

  insert into GXDBVersions values(6, 'APP_CCSInstFilterFileTableChange',  '1.4.12.2', 'APP_CCSInstFilterFileTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

