

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSIDATypeTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSIDATypeTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSIDATypeTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSIDATypeTableChange]
  delete from GXDBVersions where name = 'APP_CCSIDATypeTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSIDATypeTableChange
	ON APP_IDAType
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 8		-- APP_IDAType Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					a.clientId, @TableType, 0, @currentTime, i.type
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.appTypeId = i.type
				WHERE
					i.type NOT IN (SELECT d.type FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					a.clientId, @TableType, 1, @currentTime, i.type
				FROM
					INSERTED i
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.appTypeId = i.type
				WHERE
					i.type IN (SELECT d.type FROM DELETED d)		-- updated rows
			UNION
			SELECT
					a.clientId, @TableType, 2, @currentTime, d.type
				FROM
					DELETED d
					INNER JOIN APP_Application a  WITH (NOLOCK)
						ON a.appTypeId = d.type
				WHERE
					d.type NOT IN (SELECT i.type FROM INSERTED i)	-- existing rows deleted

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSIDATypeTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSIDATypeTableChange' AND revision = '1.6.52.1')

  insert into GXDBVersions values(6, 'APP_CCSIDATypeTableChange',  '1.6.52.1', 'APP_CCSIDATypeTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

