

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSFileTypeAndExtTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSFileTypeAndExtTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSFileTypeAndExtTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSFileTypeAndExtTableChange]
  delete from GXDBVersions where name = 'APP_CCSFileTypeAndExtTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSFileTypeAndExtTableChange
	ON App_FileTypeAndExtensions
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 19		-- App_FileTypeAndExtensions Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowXmlKeys)
			SELECT
					@AllClients, @TableType, 0, @currentTime,
					(SELECT
						'typeName' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						i.typeName AS 'tableKeys/@columnValue',
						NULL,
						'extension' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						i.extension AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d ON
						i.typeName = d.typeName
						AND i.extension = d.extension
				WHERE
					d.typeName IS NULL					-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime,
					(SELECT
						'typeName' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						i.typeName AS 'tableKeys/@columnValue',
						NULL,
						'extension' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						i.extension AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					INNER JOIN DELETED d ON
						i.typeName = d.typeName
						AND i.extension = d.extension	-- updated rows
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime,
					(SELECT
						'typeName' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						d.typeName AS 'tableKeys/@columnValue',
						NULL,
						'extension' AS 'tableKeys/@columnName',
						2 AS 'tableKeys/@columnType',
						d.extension AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					DELETED d
					LEFT OUTER JOIN DELETED i ON
						i.typeName = d.typeName
						AND i.extension = d.extension
				WHERE
					i.typeName IS NULL					-- new rows deleted

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSFileTypeAndExtTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSFileTypeAndExtTableChange' AND revision = '1.1.54.1')

  insert into GXDBVersions values(6, 'APP_CCSFileTypeAndExtTableChange',  '1.1.54.1', 'APP_CCSFileTypeAndExtTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

