

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSExtendedPropertiesTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSExtendedPropertiesTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSExtendedPropertiesTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSExtendedPropertiesTableChange]
  delete from GXDBVersions where name = 'APP_CCSExtendedPropertiesTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSExtendedPropertiesTableChange
	ON APP_ExtendedProperties
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 21		-- APP_ExtendedProperties Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowXmlKeys)
			-- All Clients
			SELECT
					CASE
						WHEN i.clientId = 1 THEN @AllClients
						ELSE i.clientId
					END,
					@TableType, 0, @currentTime,
					(SELECT
						'clientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.clientId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appTypeId AS 'tableKeys/@columnValue',
						NULL,
						'instance' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.instance AS 'tableKeys/@columnValue',
						NULL,
						'backupSet' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.backupSet AS 'tableKeys/@columnValue',
						NULL,
						'subclientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.subclientId AS 'tableKeys/@columnValue',
						NULL,
						'attrType' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.attrType AS 'tableKeys/@columnValue',
						NULL,
						'created' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.created AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					LEFT OUTER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.appTypeId = d.appTypeId
							AND i.instance = d.instance
							AND i.backupSet = d.backupSet
							AND i.subclientId = d.subClientId
							AND i.attrType = d.attrType
							AND i.created = d.created
				WHERE
					d.clientId IS NULL	-- new rows inserted
					AND (
						i.clientId <> 1
						OR (
							i.clientId = 1
							AND i.attrType = 129		-- only need this data to be shipped to CCS Laptop for default clientId 1
						)
					)
			UNION
			SELECT
					CASE
						WHEN i.clientId = 1 THEN @AllClients
						ELSE i.clientId
					END,
					@TableType, 1, @currentTime,
					(SELECT
						'clientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.clientId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appTypeId AS 'tableKeys/@columnValue',
						NULL,
						'instance' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.instance AS 'tableKeys/@columnValue',
						NULL,
						'backupSet' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.backupSet AS 'tableKeys/@columnValue',
						NULL,
						'subclientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.subclientId AS 'tableKeys/@columnValue',
						NULL,
						'attrType' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.attrType AS 'tableKeys/@columnValue',
						NULL,
						'created' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.created AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					INNER JOIN DELETED d
						ON i.clientId = d.clientId
							AND i.appTypeId = d.appTypeId
							AND i.instance = d.instance
							AND i.backupSet = d.backupSet
							AND i.subclientId = d.subClientId
							AND i.attrType = d.attrType
							AND i.created = d.created		-- updated rows
				WHERE
					(
						i.clientId <> 1
						OR (
							i.clientId = 1
							AND i.attrType = 129		-- only need this data to be shipped to CCS Laptop for default clientId 1
						)
					)
			UNION
			SELECT
					CASE
						WHEN d.clientId = 1 THEN @AllClients
						ELSE d.clientId
					END,
					@TableType, 2, @currentTime,
					(SELECT
						'clientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.clientId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.appTypeId AS 'tableKeys/@columnValue',
						NULL,
						'instance' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.instance AS 'tableKeys/@columnValue',
						NULL,
						'backupSet' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.backupSet AS 'tableKeys/@columnValue',
						NULL,
						'subclientId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.subclientId AS 'tableKeys/@columnValue',
						NULL,
						'attrType' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.attrType AS 'tableKeys/@columnValue',
						NULL,
						'created' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.created AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					DELETED d
					LEFT OUTER JOIN INSERTED i
						ON i.clientId = d.clientId
							AND i.appTypeId = d.appTypeId
							AND i.instance = d.instance
							AND i.backupSet = d.backupSet
							AND i.subclientId = d.subClientId
							AND i.attrType = d.attrType
							AND i.created = d.created
				WHERE
					i.clientId IS NULL	-- existing rows deleted
					AND (
						d.clientId <> 1
						OR (
							d.clientId = 1
							AND d.attrType = 129		-- only need this data to be shipped to CCS Laptop for default clientId 1
						)
					)

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSExtendedPropertiesTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSExtendedPropertiesTableChange' AND revision = '1.1.52.2')

  insert into GXDBVersions values(6, 'APP_CCSExtendedPropertiesTableChange',  '1.1.52.2', 'APP_CCSExtendedPropertiesTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

