

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSCommCellTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSCommCellTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSCommCellTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSCommCellTableChange]
  delete from GXDBVersions where name = 'APP_CCSCommCellTableChange' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_CCSCommCellTableChange
ON APP_CommCell
AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	SET NOCOUNT ON
	-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
	-- with the CCM Data being inserted into the Commserv Database
	IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
	BEGIN
		RETURN;
	END
	DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
	DECLARE @TableType INT = 18		-- APP_CommCell Table Type
	DECLARE @AllClients INT = -1
	-- White List of rows to capture and process later
	DECLARE @WhiteList TABLE (
		id		INT
	)
	INSERT INTO @WhiteList (id)
		SELECT
			f.value('@value', 'INTEGER') filter
		FROM APP_CCSXMLMapping WITH(NOLOCK)
			CROSS APPLY filters.nodes('/Filters/Column/Filter') n(f)
		WHERE
			id = @TableType
			AND f.value('../@name', 'NVARCHAR(128)') = 'id'
			AND f.value('../@opType', 'NVARCHAR(128)') = 'INCLUDE'
	INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
		SELECT
				@AllClients, @TableType, 0, @currentTime, i.id
			FROM
				INSERTED i
			WHERE
				i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
				AND i.id IN (SELECT id FROM @WhiteList)
		UNION
		SELECT
				@AllClients, @TableType, 1, @currentTime, i.id
			FROM
				INSERTED i
			WHERE
				i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
				AND i.id IN (SELECT id FROM @WhiteList)
		UNION
		SELECT
				@AllClients, @TableType, 2, @currentTime, d.id
			FROM
				DELETED d
			WHERE
				d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
				AND d.id IN (SELECT id FROM @WhiteList)
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSCommCellTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSCommCellTableChange' AND revision = '1.1.54.2')

  insert into GXDBVersions values(6, 'APP_CCSCommCellTableChange',  '1.1.54.2', 'APP_CCSCommCellTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

