

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSClientTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSClientTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSClientTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSClientTableChange]
  delete from GXDBVersions where name = 'APP_CCSClientTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSClientTableChange
	ON APP_Client
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 1		-- APP_Client Table Type
		DECLARE @AllClients INT = -1

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					CASE WHEN i.id IN (1, 2) THEN @AllClients ELSE i.id END,		-- If CS Client Id (default) then ship to all CCS Clients
					@TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					CASE WHEN i.id IN (1, 2) THEN @AllClients ELSE i.id END,		-- If CS Client Id (default) then ship to all CCS Clients
					@TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows

			-- On client delete cannot insert it into the the APP_WorkQueueRequest Table - so not processed

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSClientTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSClientTableChange' AND revision = '1.5.54.2')

  insert into GXDBVersions values(6, 'APP_CCSClientTableChange',  '1.5.54.2', 'APP_CCSClientTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

